/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.trace.frames;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.search.SearchState;
import org.knowm.xchart.QuickChart;
import org.knowm.xchart.XChartPanel;
import org.knowm.xchart.XYChart;
import org.knowm.xchart.style.XYStyler;

public class StatisticsPanel
extends JPanel {
    private static final String[] fieldnames = new String[]{"Variables", "Constraints", "Objective", "Solutions", "Nodes", "Fails", "Backtracks", "Backjumps", "Restarts", "Fixpoints", "Depth", "Time (sec.)", "Nodes/sec.", "Fails/sec.", "Fixpoints/sec.", "Mem. usage (MB)"};
    private static final Function<Solver, String>[] fieldvalues = new Function[]{solver -> Long.toString(solver.getModel().getNbVars()), solver -> Long.toString(solver.getModel().getNbCstrs()), solver -> solver.hasObjective() ? solver.getBestSolutionValue().toString() : "--", solver -> Long.toString(solver.getSolutionCount()), solver -> Long.toString(solver.getNodeCount()), solver -> Long.toString(solver.getFailCount()), solver -> Long.toString(solver.getBackTrackCount()), solver -> Long.toString(solver.getBackjumpCount()), solver -> Long.toString(solver.getRestartCount()), solver -> Long.toString(solver.getFixpointCount()), solver -> Long.toString(solver.getCurrentDepth()), solver -> StatisticsPanel.toHHmmss((long)(solver.getTimeCount() * 1000.0f)), solver -> String.format("%.2f", Float.valueOf((float)solver.getNodeCount() / solver.getTimeCount())), solver -> String.format("%.2f", Float.valueOf((float)solver.getFailCount() / solver.getTimeCount())), solver -> String.format("%.2f", Float.valueOf((float)solver.getFixpointCount() / solver.getTimeCount())), solver -> String.format("%d", StatisticsPanel.getUsedMemInBytes())};
    private volatile boolean alive;
    private final Solver solver;
    private final JTextField[] textFields;
    private XYChart chart;
    private XChartPanel chartpanel;
    private final List<Number> time;
    private final List<Number> obj;
    private JMenu menuChart;
    private byte chartOptions;

    public StatisticsPanel(Solver solver, long duration, JFrame mainFrame) {
        this.solver = solver;
        this.setLayout(new BorderLayout());
        int length = fieldnames.length;
        this.textFields = new JTextField[length];
        JLabel[] labels = new JLabel[length];
        for (int i = 0; i < length; ++i) {
            this.textFields[i] = new JTextField(8);
            this.textFields[i].setEnabled(false);
            this.textFields[i].setHorizontalAlignment(4);
            labels[i] = new JLabel(fieldnames[i] + ": ");
            labels[i].setLabelFor(this.textFields[i]);
        }
        JPanel textControlsPane = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        textControlsPane.setLayout(gridbag);
        this.addLabelTextRows(labels, this.textFields, textControlsPane);
        c.gridwidth = 0;
        c.anchor = 17;
        c.weightx = 1.0;
        textControlsPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Resolution statistics"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        JPanel leftPane = new JPanel(new BorderLayout());
        leftPane.add((Component)textControlsPane, "First");
        this.add((Component)leftPane, "Before");
        this.time = new ArrayList<Number>();
        this.obj = new ArrayList<Number>();
        this.chartOptions = (byte)3;
        this.makeMenu(mainFrame);
        this.printStatistics();
        Thread printer = new Thread(() -> {
            this.alive = true;
            try {
                Thread.sleep(5L);
                do {
                    if (solver.getSearchState().equals(SearchState.RUNNING)) {
                        this.printStatistics();
                        if (solver.hasObjective()) {
                            if ((this.chartOptions & 2) != 0) {
                                this.time.add(Float.valueOf(solver.getTimeCount()));
                                this.obj.add(solver.getBestSolutionValue());
                            }
                            if (this.chart == null) {
                                this.chart = QuickChart.getChart("Objective", "Time (sec)", "Objective value", solver.getObjectiveManager().getObjective().getName(), this.time, this.obj);
                                ((XYStyler)this.chart.getStyler()).setChartBackgroundColor(leftPane.getBackground());
                                this.chartpanel = new XChartPanel<XYChart>(this.chart);
                                this.add(this.chartpanel);
                                mainFrame.pack();
                            }
                            if ((this.chartOptions & 1) != 0) {
                                this.chart.updateXYSeries(solver.getObjectiveManager().getObjective().getName(), this.time, this.obj, null);
                                this.chartpanel.revalidate();
                                this.chartpanel.repaint();
                            }
                        } else {
                            this.menuChart.setEnabled(false);
                        }
                    }
                    Thread.sleep(duration);
                } while (this.alive);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
        printer.setDaemon(true);
        printer.start();
    }

    private void makeMenu(JFrame mainFrame) {
        JMenuBar menuBar = new JMenuBar();
        JMenu mainMenu = new JMenu("Menu");
        mainMenu.setMnemonic(77);
        menuBar.add(mainMenu);
        mainFrame.setJMenuBar(menuBar);
        this.menuChart = new JMenu("Chart");
        this.menuChart.setMnemonic(67);
        this.menuChart.add(this.makeShowHideItem(mainFrame));
        this.menuChart.add(this.makeDisconnectConnectItem(mainFrame));
        mainMenu.add(this.menuChart);
    }

    private JMenuItem makeDisconnectConnectItem(JFrame mainFrame) {
        JMenuItem item = new JMenuItem("Disconnect", 68);
        item.setAccelerator(KeyStroke.getKeyStroke(68, 512));
        item.addActionListener(e -> {
            if ((this.chartOptions & 2) != 0) {
                this.remove(this.chartpanel);
            }
            this.chartOptions = 0;
            this.time.clear();
            this.obj.clear();
            mainFrame.pack();
        });
        return item;
    }

    private JMenuItem makeShowHideItem(JFrame mainFrame) {
        JMenuItem item = new JMenuItem("Hide/Show", 72);
        item.setAccelerator(KeyStroke.getKeyStroke(72, 512));
        item.addActionListener(e -> {
            if ((this.chartOptions & 2) != 0) {
                this.remove(this.chartpanel);
                this.chartOptions = (byte)(this.chartOptions ^ 2);
            } else {
                this.add(this.chartpanel);
                this.chartOptions = (byte)3;
            }
            mainFrame.pack();
        });
        return item;
    }

    private void addLabelTextRows(JLabel[] labels, JTextField[] textFields, Container container) {
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 13;
        int numLabels = labels.length;
        for (int i = 0; i < numLabels; ++i) {
            c.gridwidth = -1;
            c.fill = 0;
            c.weightx = 0.0;
            container.add((Component)labels[i], c);
            c.gridwidth = 0;
            c.fill = 2;
            c.weightx = 1.0;
            container.add((Component)textFields[i], c);
        }
    }

    private void printStatistics() {
        for (int i = 0; i < this.textFields.length; ++i) {
            this.textFields[i].setText(fieldvalues[i].apply(this.solver));
        }
    }

    private static String toHHmmss(long etime) {
        return String.format("%02d:%02d:%02d", TimeUnit.MILLISECONDS.toHours(etime), TimeUnit.MILLISECONDS.toMinutes(etime) % TimeUnit.HOURS.toMinutes(1L), TimeUnit.MILLISECONDS.toSeconds(etime) % TimeUnit.MINUTES.toSeconds(1L));
    }

    private static long getUsedMemInBytes() {
        long usedHeapMemoryAfterLastGC = 0L;
        ArrayList<MemoryPoolMXBean> memoryPools = new ArrayList<MemoryPoolMXBean>(ManagementFactory.getMemoryPoolMXBeans());
        for (MemoryPoolMXBean memoryPool : memoryPools) {
            if (!memoryPool.getType().equals((Object)MemoryType.HEAP)) continue;
            MemoryUsage poolCollectionMemoryUsage = memoryPool.getUsage();
            usedHeapMemoryAfterLastGC += poolCollectionMemoryUsage.getUsed();
        }
        return (long)((double)usedHeapMemoryAfterLastGC / 1000000.0);
    }
}

