/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.objects.setDataStructures.bitset;

import java.util.BitSet;
import org.chocosolver.util.objects.setDataStructures.AbstractSet;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.objects.setDataStructures.SetType;

public class Set_BitSet
extends AbstractSet
implements ISet.WithOffset {
    protected int card = 0;
    protected int offset;
    protected BitSet values = new BitSet();
    private final ISetIterator iter = this.newIterator();

    @Override
    public ISetIterator iterator() {
        this.iter.reset();
        return this.iter;
    }

    @Override
    public ISetIterator newIterator() {
        return new ISetIterator(){
            private int current = -1;

            @Override
            public void reset() {
                this.current = -1;
            }

            @Override
            public boolean hasNext() {
                return Set_BitSet.this.values.nextSetBit(this.current + 1) >= 0;
            }

            @Override
            public int nextInt() {
                this.current = Set_BitSet.this.values.nextSetBit(this.current + 1);
                return this.current + Set_BitSet.this.offset;
            }
        };
    }

    public Set_BitSet(int offSet) {
        this.offset = offSet;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public boolean add(int element) {
        if (element < this.offset) {
            throw new IllegalStateException("Cannot add " + element + " to set of offset " + this.offset);
        }
        if (this.values.get(element - this.offset)) {
            return false;
        }
        ++this.card;
        this.values.set(element - this.offset);
        this.notifyObservingElementAdded(element);
        return true;
    }

    @Override
    public boolean remove(int element) {
        if (this.contains(element)) {
            this.values.clear(element - this.offset);
            --this.card;
            this.notifyObservingElementRemoved(element);
            return true;
        }
        return false;
    }

    public int previousValue(int val) {
        if (this.isEmpty()) {
            return this.offset - 1;
        }
        return this.offset + this.values.previousSetBit(val);
    }

    public int nextValue(int val) {
        if (this.isEmpty()) {
            return this.offset - 1;
        }
        return this.offset + this.values.nextSetBit(val);
    }

    @Override
    public boolean contains(int element) {
        return element >= this.offset && this.values.get(element - this.offset);
    }

    @Override
    public int size() {
        return this.card;
    }

    @Override
    public void clear() {
        this.card = 0;
        this.values.clear();
        this.notifyObservingCleared();
    }

    @Override
    public int min() {
        if (this.isEmpty()) {
            throw new IllegalStateException("cannot find minimum of an empty set");
        }
        return this.offset + this.values.nextSetBit(0);
    }

    @Override
    public int max() {
        if (this.isEmpty()) {
            throw new IllegalStateException("cannot find maximum of an empty set");
        }
        return this.offset + this.values.previousSetBit(this.values.length());
    }

    @Override
    public SetType getSetType() {
        return SetType.BITSET;
    }

    @Override
    public String toString() {
        StringBuilder st = new StringBuilder("{");
        ISetIterator iter = this.newIterator();
        while (iter.hasNext()) {
            st.append(iter.nextInt()).append(", ");
        }
        st.append("}");
        return st.toString().replace(", }", "}");
    }
}

