% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/institution_search.R
\name{institution_search}
\alias{institution_search}
\alias{institution_export}
\title{Search GRSciColl institutions}
\usage{
institution_search(
  query = NULL,
  type = NULL,
  institutionalGovernance = NULL,
  disciplines = NULL,
  name = NULL,
  fuzzyName = NULL,
  numberSpecimens = NULL,
  occurrenceCount = NULL,
  typeSpecimenCount = NULL,
  sourceId = NULL,
  source = NULL,
  code = NULL,
  alternativeCode = NULL,
  contact = NULL,
  institutionKey = NULL,
  country = NULL,
  city = NULL,
  gbifRegion = NULL,
  machineTagNamespace = NULL,
  machineTagName = NULL,
  machineTagValue = NULL,
  identifier = NULL,
  identifierType = NULL,
  active = NULL,
  displayOnNHCPortal = NULL,
  masterSourceType = NULL,
  replacedBy = NULL,
  sortBy = NULL,
  sortOrder = NULL,
  offset = NULL,
  limit = NULL,
  format = NULL,
  curlopts = list(http_version = 2)
)

institution_export(
  query = NULL,
  type = NULL,
  institutionalGovernance = NULL,
  disciplines = NULL,
  name = NULL,
  fuzzyName = NULL,
  numberSpecimens = NULL,
  occurrenceCount = NULL,
  typeSpecimenCount = NULL,
  sourceId = NULL,
  source = NULL,
  code = NULL,
  alternativeCode = NULL,
  contact = NULL,
  institutionKey = NULL,
  country = NULL,
  city = NULL,
  gbifRegion = NULL,
  machineTagNamespace = NULL,
  machineTagName = NULL,
  machineTagValue = NULL,
  identifier = NULL,
  identifierType = NULL,
  active = NULL,
  displayOnNHCPortal = NULL,
  masterSourceType = NULL,
  replacedBy = NULL,
  sortBy = NULL,
  sortOrder = NULL,
  offset = NULL,
  limit = NULL,
  format = "TSV",
  curlopts = list()
)
}
\arguments{
\item{query}{(character) Simple full text search parameter. The value for
this parameter can be a simple word or a phrase. Wildcards are not supported}

\item{type}{(character) Type of a GrSciColl institution
Available values : BIOMEDICAL_RESEARCH_INSTITUTE, BOTANICAL_GARDEN,
HERBARIUM, LIVING_ORGANISM_COLLECTION, MEDICAL_RESEARCH_INSTITUTE, MUSEUM,
MUSEUM_HERBARIUM_PRIVATE_NON_PROFIT, OTHER_INSTITUTIONAL_TYPE,
OTHER_TYPE_RESEARCH_INSTITUTION_BIOREPOSITORY, UNIVERSITY_COLLEGE,
ZOO_AQUARIUM}

\item{institutionalGovernance}{(character) Instutional governance of a
GrSciColl institution Available values : ACADEMIC_FEDERAL,
ACADEMIC_FOR_PROFIT, ACADEMIC_LOCAL, ACADEMIC_NON_PROFIT, ACADEMIC_STATE,
FEDERAL, FOR_PROFIT, LOCAL, NON_PROFIT, OTHER, STATE.}

\item{disciplines}{(character) Discipline of a GrSciColl institution.
Check available values :
https://techdocs.gbif.org/en/openapi/v1/registry#/Institutions/listInstitutions}

\item{name}{(character) Name of a GrSciColl institution or collection}

\item{fuzzyName}{(character) It searches by name fuzzily so the parameter
doesn't have to be the exact name.}

\item{numberSpecimens}{(character) Number of specimens. It supports ranges
and a \code{*} can be used as a wildcard.}

\item{occurrenceCount}{(character) Count of occurrences linked. It supports
ranges and a \code{*} can be used as a wildcard.}

\item{typeSpecimenCount}{(character) Count of type specimens linked. It
supports ranges and a \code{*} can be used as a wildcard.}

\item{sourceId}{(character) sourceId of MasterSourceMetadata}

\item{source}{(character) Source attribute of MasterSourceMetadata
Available values : DATASET, ORGANIZATION, IH_IRN}

\item{code}{(character) Code of a GrSciColl institution or collection.}

\item{alternativeCode}{(character) Alternative code of a GrSciColl institution.}

\item{contact}{(character) Filters collections and institutions whose
contacts contain the person key specified.}

\item{institutionKey}{(character) Keys of institutions to filter by.}

\item{country}{(character) Filters by country given as a ISO 639-1 (2 letter)
country code.}

\item{city}{(character) Filters by the city of the address. It searches in both the
physical and the mailing address.}

\item{gbifRegion}{(character) Filters by a gbif region. Available values : AFRICA, ASIA,
EUROPE, NORTH_AMERICA, OCEANIA, LATIN_AMERICA, ANTARCTICA.}

\item{machineTagNamespace}{(character) Filters for entities with a machine
tag in the specified namespace.}

\item{machineTagName}{(character) Filters for entities with a machine tag
with the specified name (use in combination with the machineTagNamespace
parameter).}

\item{machineTagValue}{(character) Filters for entities with a machine tag
with the specified value (use in combination with the machineTagNamespace and
machineTagName parameters).}

\item{identifier}{(character) An identifier of the type given by the
\code{identifierType} parameter, for example a DOI or UUID.}

\item{identifierType}{(character) An identifier type for the
identifier parameter.
Available values : URL, LSID, HANDLER, DOI, UUID, FTP, URI, UNKNOWN,
GBIF_PORTAL, GBIF_NODE, GBIF_PARTICIPANT, GRSCICOLL_ID, GRSCICOLL_URI,
IH_IRN, ROR, GRID, CITES, SYMBIOTA_UUID, WIKIDATA, NCBI_BIOCOLLECTION, ISIL,
CLB_DATASET_KEY.}

\item{active}{(logical) Active status of a GrSciColl institution or collection.}

\item{displayOnNHCPortal}{(logical) Flag to show this record in the NHC
portal.}

\item{masterSourceType}{(character) The master source type of a GRSciColl
institution or collection. Available values : GRSCICOLL, GBIF_REGISTRY, IH.}

\item{replacedBy}{(character) Key of the entity that replaced another entity.}

\item{sortBy}{(character) Field to sort the results by. It only supports the
fields contained in the enum. Available values : NUMBER_SPECIMENS.}

\item{sortOrder}{(character) Sort order to use with the sortBy parameter.
Available values : ASC, DESC.}

\item{offset}{(numeric) Determines the offset for the search results.}

\item{limit}{(numeric) Controls the number of results in the page.
Default 20.}

\item{format}{(character) Format of the export. Default is "TSV". Only used
for \link{institution_export}.}

\item{curlopts}{(list) curlopts options passed on to \link[crul:HttpClient]{crul::HttpClient}.}
}
\value{
A \code{list}
}
\description{
Search GRSciColl institutions
}
\details{
Will return GRSciColl collections data. \link{institution_export} will
return all of the results in a single \code{tibble}, while \link{institution_search} will
return a sample of results.
}
\examples{
\dontrun{
institution_search(query="Kansas",limit=1)
institution_search(numberSpecimens = "1000,*",limit=2)
institution_search(source = "IH_IRN") 
institution_search(country = "US;GB")
institution_search(typeSpecimenCount = "10,100")

}
}
