#' Get Account Details For All Accounts
#'
#' @name accounts
#'
#' @description This is an auth based function. User must have valid api keys generated by GADX which must be passed as mandatory arguments. The function takes no additional arguments and returns the account details for all accounts linked to that authenticated user.  The account details currently include information about the currency (fiat or crypto) and the details on the balance (total, available and help for other transactions). All accounts are returned even if have zero balance.
#'
#' @param api.key Mandatory character value. This is the API key as generated by GDAX. Typically a 32 character value.
#' @param secret Mandatory character value. This is the API secret as generated by GDAX. Typically a 88 character value.
#' @param passphrase Mandatory character value. This is the passphrase as generated by GDAX. Typically a 11 character value.
#'
#' @return  Dataframe with a single row for each account_id, the currency, the current balance, available, holds and profile_id of the user.
#'
#' @examples
#' \dontrun{
#' accounts(api.key = your_key, secret = your_api_secret, passphrase = your_api_pass)
#' }
#'
#' @export

accounts <- function(api.key,
                     secret,
                     passphrase)  {
  #get url extension----
  req.url <-  "/accounts/"

  #define method----
  method <- "GET"

  #fetch response----
  response <- auth(
    method = method,
    req.url = req.url,
    api.key = api.key,
    secret = secret,
    passphrase = passphrase
  )

  #transform----
  response <- as.data.frame(response)
  response$balance <- as.numeric(response$balance)
  response$available <- as.numeric(response$available)
  response$hold <- as.numeric(response$hold)

  #return----
  return(response)
}
