% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{power_plots}
\alias{power_plots}
\title{Returns a set of plots summarising the expected power to detect a significant
effect given various allele fraction and effect size combinations.}
\usage{
power_plots(del_result, allele_min_reads = 100, WT_fraction = NA)
}
\arguments{
\item{del_result}{Result from a call to deletion_analysis.}

\item{allele_min_reads}{The minimum number of reads that a deletion allele must have across all replicates to be included.}

\item{WT_fraction}{If specified, then the model will assume this fraction of WT reads}
}
\value{
Returns a list with three ggplot objects:
\itemize{
  \item cv_plot
  \item power_plot
  \item replicate_allocation_plot
}
}
\description{
Returns a set of plots summarising the expected power to detect a significant
effect given various allele fraction and effect size combinations.
}
\examples{
# Note: First run deletion_analysis()
# mul1_del_results is a pre-loaded result

power_plots(mul1_del_results[[1]])
}
\seealso{
\code{\link{deletion_analysis}}
}
