% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lisa.R
\name{local_moran_eb}
\alias{local_moran_eb}
\title{Local Moran with Empirical Bayes(EB) Rate}
\usage{
local_moran_eb(
  w,
  df,
  permutations = 999,
  permutation_method = "complete",
  significance_cutoff = 0.05,
  cpu_threads = 6,
  seed = 123456789
)
}
\arguments{
\item{w}{An instance of Weight object}

\item{df}{A data frame with two selected variable: one is "event", anothor
is "base" variable. E.g. guerry[c("hr60", "po60")]}

\item{permutations}{(optional) The number of permutations for the LISA
computation}

\item{permutation_method}{(optional) The permutation method used for the LISA
computation. Options are {'complete', 'lookup'}. Default is 'complete'.}

\item{significance_cutoff}{(optional) A cutoff value for significance
p-values to filter not-significant clusters}

\item{cpu_threads}{(optional) The number of cpu threads used for parallel
LISA computation}

\item{seed}{(optional) The seed for random number generator}
}
\value{
An instance of LISA-class
}
\description{
The function to apply local Moran with EB Rate statistics. The
EB rate is first computed from "event" and "base" variables, and then used
in local moran statistics.
}
\examples{
\dontrun{
library(sf)
nat <- st_read("natregimes.shp")
nat_w <- queen_weights(nat)
lisa <- local_moran_eb(queen_w, guerry[c("hr60", "po60")])
lms <- lisa_values(lisa)
lms
}
}
