% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/harm_mean_pred.R
\name{harm_mean_pred}
\alias{harm_mean_pred}
\title{Calculation of Harmonic Mean for Geographic Profiling}
\usage{
harm_mean_pred(lat, lon)
}
\arguments{
\item{lat}{a vector of latitudes for the crime incident series}

\item{lon}{a vector of latitudes for the crime incident series}
}
\value{
A latitude and longitude point of the harmonic mean of the incidents.
    This mean can be used to prioritize the area which contains the offender's
    anchor point.
}
\description{
A calculation of the harmonic mean for serial crime
    analysis. This function is among the centrographic methods which have
    been used for geographic profiling. The model assumes that the serial
    perpetrator's home base is relatively central among the crime incidents.
}
\examples{
#Using provided dataset for the Boston Strangler Incidents:
data(desalvo)
harm_mean_pred(desalvo$lat, desalvo$lon)
}
\author{
Jamie Spaulding, Keith Morris
}
\keyword{methods}
\keyword{spatial}
