% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/native.R
\name{create_data_table}
\alias{create_data_table}
\title{Create and upload data into a table in slides}
\usage{
create_data_table(
  id = NULL,
  page_element_property = NULL,
  data = NULL,
  headers = TRUE
)
}
\arguments{
\item{id}{ID of the presentation slide}

\item{page_element_property}{A list that contains a page element property. The page element is to be
generated by the page_element_property function in this package.}

\item{data}{Dataframe of the dataset that is to be converted so that it can be used with the google slides API}

\item{headers}{Boolean to indicate whether to convert taking in mind of the headers or not}
}
\description{
This function takes in one single page element property and one dataset at each time
for uploading to a single slide
}
\examples{
\dontrun{
library(googleslides)
authorize()
slide_page <- page_element_property(['slide-id-2'])
create_data_table("presentation-slide-id", slide_page, iris[1:5,])
}
}
