\name{xyplot.tags}
\alias{xyplot.tags}
\title{ Display a Plot of Posted Values for a Third Variable}
\description{ Displays a x-y plot where the data for a third variable are represented by the \sQuote{written} values of the data at their x-y position. }
\usage{
xyplot.tags(xx, yy, tag, log = NULL, xlim = NULL, ylim = NULL,
        xlab = deparse(substitute(xx)), ylab = deparse(substitute(yy)),
        taglab = deparse(substitute(tag)),  main = "", ...)
}
\arguments{
  \item{xx}{ name of the x-axis variable. }
  \item{yy}{ name of the y-axis variable. }
  \item{tag}{ name of the third variable to be displayed. }
  \item{log}{ if it is required to display the data with logarithmic axis scaling, set \code{log = "x"} for a logarithmically scaled x-axis, \code{log = "y"} for a logarithmically scaled y-axis, and \code{log = "xy"} for both axes logarithmically scaled. }
  \item{xlim}{ user defined limits for the x-axis, see Details below. }
  \item{ylim}{ user defined limits for the y-axis, see Details below. }
  \item{xlab}{ the x-axis title, by default the variable name, \code{deparse(substitute(xx))}. It is often desirable to replace the default x-axis title of the input variable name text string with a more informative title, e.g., \code{xlab = "Fe (mg/kg) in stream sediment"}. }
  \item{ylab}{ the y-axis title, by default the variable name, \code{deparse(substitute(yy))}. It is often desirable to replace the default y-axis title of the input variable name text string with a more informative title, e.g., \code{ylab = "Mn (mg/kg) in stream sediment"}. }
  \item{taglab}{ text to be inserted in the plot title, by default \code{deparse{substitute{tag}}} is used.  See Details below. }
  \item{main}{ an alternative plot title, see Details below. }
  \item{\dots}{ further arguments to be passed to methods.  For example, if smaller plotting characters are required, specify \code{cex = 0.8}; or if some colour other than black is required for the plotting characters, specify \code{col = 2} to obtain red (see \code{\link{display.lty}} for the default colour palette).  If it is required to make the plot title smaller, add \code{cex.main = 0.9} to reduce the font size by 10\%. }
}
\details{
If \code{taglab} and \code{main} are undefined a default a plot title is generated by appending the input variable name text string to "Plot of Values for ".  If no plot title is required set \code{zlab = " "}, or if an alternative to the variable name \code{taglab} is required it may be specified, \code{taglab = "Alternative"}.  If some user defined plot title is required it should be defined in \code{main}, e.g., \code{main = "Plot Title Text"}, in which instance \code{taglab} is ignored.

If the default selection for \code{xlim} is inappropriate it can be set, e.g., \code{xlim = c(0, 200)} or \code{c(2, 200)}, the latter being appropriate for a logarithmically scaled plot, i.e. \code{log  = "x"}.  If the defined limits lie within the observed data range a truncated plot will be displayed.  The same procedure applies to setting \code{ylim}. 

If a plot of sample numbers, \sQuote{IDs}, is required and they are not explicitly in the dataframe, a plot of dataframe row numbers may be displayed by specifying \code{dimnames(dfname)[[1]]} as the value of \code{tags}.
}
\note{
Any less than detection limit values represented by negative values, or zeros or other numeric codes representing blanks in the data vector, must be removed prior to executing this function, see \code{\link{ltdl.fix.df}}.

Any \code{NA}s in the x-y coordinate vectors are removed prior to displaying the plot, thus those \sQuote{data} are not plotted.  However, any \code{NA}s in the third variable to be plotted are replaced with a \sQuote{+} sign to indicate data for the third variable are \sQuote{missing}.
}
\author{ Robert G. Garrett }
\seealso{ \code{\link{ltdl.fix.df}}, \code{\link{remove.na}}, \code{\link{display.lty}} }
\examples{
## Make test data available
data(sind)
attach(sind)

## Plot the sample site IDs in the x-y space
xyplot.tags(Fe, Mn, ID)

## Plot the dataframe row numbers in the x-y space and appropiately
## scale the y-axis
xyplot.tags(Fe, Mn, dimnames(sind)[[1]], log = "y")

## Plot the values for zinc (Zn) in smaller red text in the x-y
## space, providing more appropriate axis scaling and labelling,
## and adding a user specified title
xyplot.tags(Fe, Mn, Zn, log = "y", xlab = "Fe (pct) in stream sediment",
	ylab = "Mn (mg/kg) in stream sediment",
	main = "Howarth & Sinding-Larsen Test Data\nZn (mg/kg)", cex = 0.8, col = 2) 

## Detach test data
detach(sind) 
}
\keyword{ hplot }

