% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_gps.R
\name{plot_gps}
\alias{plot_gps}
\title{Plot the propensity score by treatment}
\usage{
plot_gps(trt, X, method = "Multinomial")
}
\arguments{
\item{trt}{A numeric vector representing the treatment groups.}

\item{X}{A dataframe or matrix, including all the covariates but not treatments, with  rows corresponding to observations and columns to variables.}

\item{method}{A character indicating how to estimate the propensity score. The default is "Multinomial", which uses multinomial regression to estimate the propensity score.}
}
\value{
A plot
}
\description{
This function estimates the propensity score for each treatment group and then plot the propensity score by each treatment to check covariate overlap.
}
\examples{
library(riAFTBART)
set.seed(20181223)
n = 50      # number of clusters
k = 50      # cluster size
N = n*k     # total sample size
cluster.id = rep(1:n, each=k)
tau.error = 0.8
b = stats::rnorm(n, 0, tau.error)
alpha = 2
beta1 = 1
beta2 = -1
sig.error = 0.5
censoring.rate = 0.02
x1 = stats::rnorm(N,0.5,1)
x2 = stats::rnorm(N,1.5,0.5)
trt.train = sample(c(1,2,3), N, prob = c(0.4,0.3,0.2), replace = TRUE)
plot_gps(trt = trt.train, X = cbind(x1, x2))
}
