% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coeffTable.R
\name{coeffTable}
\alias{coeffTable}
\title{Table of pairwise relatedness coefficients}
\usage{
coeffTable(x, ids = labels(x), coeffs = c("f", "phi", "deg", "kappa", "Delta"))
}
\arguments{
\item{x}{A pedigree in the form of a pedtools::ped object.}

\item{ids}{A character (or coercible to character) containing ID labels of
two or more pedigree members.}

\item{coeffs}{A character vector containing one or more of the keywords "f",
"phi", "deg", "kappa", "Delta".}
}
\value{
A data frame.
}
\description{
Creates a data frame containing various relatedness coefficients between all
pairs of individuals in a given pedigree.
}
\details{
Available coefficients (indicated in \code{coeffs}) include:
\itemize{
\item f: The inbreeding coefficient of each pair member. Columns: \code{f1} and \code{f2}.
\item phi: The kinship coefficient. Column: \code{phi}.
\item deg: The degree of relationship, as computed by \link{kin2deg}. Column: \code{deg}
\item kappa: The IBD coefficients computed by \link{kappaIBD}. (These are NA for pairs
involving inbred individuals.) Columns: \code{kappa0}, \code{kappa1}, \code{kappa2}.
\item Delta: The condensed identity coefficients of Jacquard, computed by
\code{\link[=condensedIdentity]{condensedIdentity()}}. Columns: \code{D1}, ..., \code{D9}.
}
}
\examples{
# Uncle-nephew pedigree
x = addSon(nuclearPed(2), 4)

# Complete table
coeffTable(x)

# Only relevant coefficients
coeffTable(x, coeffs = c("phi", "deg", "kappa"))

# Only the uncle-nephew pair
coeffTable(x, ids = c(3, 6), coeffs = c("phi", "deg", "kappa"))
}
