% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/condensedIdentity.R
\name{condensedIdentity}
\alias{condensedIdentity}
\title{Condensed identity coefficients}
\usage{
condensedIdentity(
  x,
  ids,
  sparse = NA,
  simplify = TRUE,
  self = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{x}{A pedigree in the form of a \code{\link[pedtools:ped]{pedtools::ped}} object}

\item{ids}{A character (or coercible to character) containing ID labels of
two or more pedigree members.}

\item{sparse}{A positive integer, indicating the pedigree size limit for
using sparse arrays (as implemented by the
\href{https://CRAN.R-project.org/package=slam}{slam} package) instead of
ordinary arrays.}

\item{simplify}{Simplify the output (to a numeric of length 9) if \code{ids} has
length 2. Default: TRUE.}

\item{self}{A logical indicating if self-relationships (i.e., between a
pedigree member and itself) should be included. FALSE by default.}

\item{verbose}{A logical}
}
\value{
If \code{ids} has length 2 and \code{simplify = TRUE}: A vector of length 9,
containing the condensed identity coefficients.

Otherwise, a data frame with 11 columns and one row for each pair of
individuals. The first two columns contain the ID labels, and columns 3-11
contain the condensed identity coefficients.
}
\description{
Computes the 9 condensed identity coefficients of pairwise relationships in a
pedigree. Founders of the pedigree may be inbred; use
\code{\link[pedtools:founderInbreeding]{pedtools::founderInbreeding()}} to set this up.
}
\details{
The implementation is a modified version of Karigl's recursive algorithm
(1981).
}
\examples{
# One generation of full sib mating.
# (One of the simplest examples with all 9 coefficients nonzero.)
x = fullSibMating(1)
j1 = condensedIdentity(x, ids = 5:6)

stopifnot(all.equal(j1, c(2, 1,4, 1, 4, 1, 7, 10, 2)/32))

# Recalculate the coefficients when the founders are 100\% inbred
founderInbreeding(x, 1:2) = 1
condensedIdentity(x, ids = 5:6)

}
\references{
G. Karigl (1981). \emph{A recursive algorithm for the calculation of
identity coefficients.} Annals of Human Genetics, vol. 45.
}
\seealso{
\code{\link[=kappa]{kappa()}}, \code{\link[=identityCoefs]{identityCoefs()}}, \code{\link[pedtools:founderInbreeding]{pedtools::founderInbreeding()}}
}
