% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ibdTriangle.R
\name{ibdTriangle}
\alias{ibdTriangle}
\title{IBD triangle plot}
\usage{
ibdTriangle(
  relationships = c("UN", "PO", "MZ", "S", "H,U,G", "FC"),
  plotType = c("base", "ggplot2", "plotly"),
  pch = 19,
  cexPoint = 1.2,
  cexText = 1.2,
  cexAxis = cexText,
  kinshipLines = numeric(),
  shortLines = FALSE,
  shading = "gray90",
  xlim = c(0, 1),
  ylim = c(0, 1),
  axes = FALSE,
  las = 1,
  xlab = expression(kappa[0]),
  ylab = expression(kappa[2]),
  title = NULL,
  mar = c(2.1, 2.1, 1, 1),
  xpd = TRUE,
  keep.par = TRUE,
  cexLab = NULL,
  ...
)
}
\arguments{
\item{relationships}{A character vector indicating the \emph{fixed} relationships
points to be included in the plot. Valid entries are those in the \code{label}
column of \link{basicRelationships}.}

\item{plotType}{Either "base" (default), "ggplot2" or "plotly". Abbreviations
are allowed.}

\item{pch}{Symbol used for the relationship points (see \code{\link[=par]{par()}}).}

\item{cexPoint}{A number controlling the symbol size for the relationship
points.}

\item{cexText}{A number controlling the font size for the relationship
labels.}

\item{cexAxis}{A number controlling the font size for the axis labels.}

\item{kinshipLines}{A numeric vector (see Details).}

\item{shortLines}{A logical indicating if the kinship lines (if present)
should be restricted to the interior of the triangle.}

\item{shading}{The shading colour for the unattainable region.}

\item{xlim, ylim, xpd, las}{Graphical parameters; see \code{\link[=par]{par()}}. (Base plot only.)}

\item{axes}{A logical: Draw surrounding axis box? Default: \code{FALSE}.}

\item{xlab, ylab}{Axis labels.}

\item{title}{Main title (absent by default).}

\item{mar}{Graphical parameter; see \code{\link[=par]{par()}}. For ggplot2, this is ignored
unless it is a ggplot2::margin() object.}

\item{keep.par}{A logical. If TRUE, the graphical parameters are not reset
after plotting, which may be useful for adding additional annotation. (Base
plot only.)}

\item{cexLab}{Deprecated; use \code{cexAxis} instead.}

\item{\dots}{Further arguments; currently not used.}
}
\value{
\code{NULL} if \code{plotType = 'base'}; otherwise the plot object.
}
\description{
A relationship triangle used to used to visualize the kappa coefficients of
between non-inbred individuals. Various annotations are available, including
points marking the most common relationships, contour lines for the kinship
coefficients, and shading of the unattainable region. The companion function
\code{\link[=showInTriangle]{showInTriangle()}} (which plots user-specified points onto the triangle) is
probably the most useful for end users.
}
\details{
For any pair of non-inbred individuals A and B, their genetic relationship
can be summarized by the IBD coefficients \eqn{(\kappa_0, \kappa_1,
\kappa_2)}{(\kappa0, \kappa1, \kappa2)}, where \eqn{\kappa_i} = P(A and B
share i alleles IBD at random autosomal locus). Since \eqn{\kappa_0 +
\kappa_1 + \kappa_2 = 1}{\kappa0 + \kappa1 + \kappa2 = 1}, any relationship
corresponds to a point in the triangle in the \eqn{(\kappa_0,
\kappa_2)}{(\kappa0, \kappa2)}-plane defined by \eqn{\kappa_0 \ge 0, \kappa_2
\ge 0, \kappa_0 + \kappa_2 \le 1}{\kappa0 \ge 0, \kappa2 \ge 0, \kappa0 +
\kappa2 \le 1}. The choice of \eqn{\kappa_0}{\kappa0} and
\eqn{\kappa_2}{\kappa2} as the axis variables is done for reasons of symmetry
and is not significant (other authors have used different views of the
triangle).

As shown by Thompson (1976), points in the subset of the triangle defined by
\eqn{4\kappa_0\kappa_2 > \kappa_1^2}{4*\kappa0*\kappa2 > \kappa1^2} are
unattainable for pairwise relationships. By default this region in shaded in
a light grey colour, but this can be modified with the \code{shading} argument.

The IBD coefficients are linearly related to the kinship coefficient
\eqn{\varphi} by the formula \eqn{\varphi = 0.25\kappa_1 + 0.5\kappa_2.}{\phi =
0.25*\kappa1 + 0.5*\kappa2.} By indicating values for \eqn{\varphi} in the
\code{kinshipLines} argument, the corresponding contour lines are shown in the
triangle plot. (Currently only when \code{plotType = "base"}.)
}
\examples{
opar = par(no.readonly = TRUE) # store graphical parameters

ibdTriangle()
ibdTriangle(kinshipLines = c(0.25, 0.125), shading = NULL, cexText = 0.7)
ibdTriangle(kinshipLines = c(0.25, 0.125), shortLines = TRUE, pch = 15)
ibdTriangle(relationships = c("UN", "PO", "MZ", "S"),
            xlab = "k0", ylab = "k2", las = 0, axes = TRUE, cexAxis =1.6)

par(opar) # reset graphical parameters

}
\references{
\itemize{
\item E. A. Thompson (1975). \emph{The estimation of pairwise relationships.} Annals
of Human Genetics 39.
\item E. A. Thompson (1976). \emph{A restriction on the space of genetic
relationships.} Annals of Human Genetics 40.
}
}
\seealso{
\code{\link[=showInTriangle]{showInTriangle()}}, \code{\link[=kappaIBD]{kappaIBD()}}
}
