% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc.R
\name{decontaminate}
\alias{decontaminate}
\title{Calculate the amount of contamination to explain an observed C14 age}
\usage{
decontaminate(y.obs, y.real, F14C = 1, decimals = 2, visualise = TRUE)
}
\arguments{
\item{y.obs}{the observed radiocarbon age}

\item{y.real}{the 'true' radiocarbon age}

\item{F14C}{the F14C of the contamination. Set at 1 for carbon of modern radiocarbon age, at 0 for 14C-free carbon, or anywhere inbetween.}

\item{decimals}{Rounding of the output. Since details matter here, the default is to provide 5 decimals.}

\item{visualise}{By default, a plot is made to visualise the real and observed F14C values, together with the inferred contamination.}
}
\value{
The required contamination (as percentage), as well as a plot
}
\description{
Given an observed and a 'true' radiocarbon age, calculate the amount of contamination required to explain the observed age.
}
\examples{
  decontaminate(600, 2000, 1)
}
\author{
Maarten Blaauw
}
