\name{coef.ridgeLogistic}
\alias{coef.ridgeLogistic}

\title{
  Extract the coefficients from a logistic ridge regression fit computed
  by a call to \code{logisticRidge}.
}
\description{
  Extract the coefficients from a logistic ridge regression fit computed
  by a call to \code{logisticRidge}.
  Where the ridge parameter was chosen automatically (using \code{lambda
  = "automatic"}, optionally print the coefficients corresponding to the
  ridge parameter computed using all numbers of principal components.
}
\usage{
\method{coef}{ridgeLogistic}(object, all.coef = FALSE, ...)
}

\arguments{
  \item{object}{
    A \code{ridgeLogistic} object, typically generated by a call to \code{logisticRidge}.
}
  \item{all.coef}{
    Logical. If \code{lambda = "automatic"}, should results be returned
      for all ridge regression penalty paramters?
}
  \item{\dots}{
    Additional arguments to be passed to or from other methods. 
}
}
\details{
  If \code{logisticRidge} was called with \code{lambda = "automatic"}
  then \code{coef.ridgeLogistic} will only print the regression
  coefficients fitted using the automatically chosen ridge parameter. To print the
  regression coefficients for all values of the shrinkage parameter, use
  \code{all.coef = TRUE}.
  Otherwise, all the coefficients are printed.
}
\value{
A numeric vector or matrix of ridge regression coefficients.
}
\references{
  A semi-automatic method to guide the choice of ridge parameter in ridge
  regression. Cule, E. and De Iorio, M. (2012) arXiv:1205.0686v1
}
\author{
  Erika Cule
}
\seealso{
\code{\link{logisticRidge}}
}
\examples{
data(GenBin)
mod <- logisticRidge(Phenotypes ~ ., data = as.data.frame(GenBin))
coef(mod)
coef(mod, all.coef = TRUE)
}

