% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Frechet.R
\name{frechet}
\alias{frechet}
\alias{frechet_mean}
\alias{frechet_ss}
\title{Fréchet statistics on the torus}
\usage{
frechet_mean(x, l = pi, N = 500, draw_plot = FALSE)

frechet_ss(x, l = pi, N = 500, draw_plot = FALSE)
}
\arguments{
\item{x}{sample of angles on \eqn{[-l, l)}, a vector or a matrix.}

\item{l}{half-period of the circular data. Can be a vector of length
\code{ncol(x)} if \code{x} is a matrix. Defaults to \code{pi}.}

\item{N}{size of the grid in \eqn{[-l, l)} for the exhaustive search of
the mean. Defaults to \code{5e2}.}

\item{draw_plot}{draw a diagnostic plot showing the Fréchet loss function?
Defaults to \code{FALSE}.}
}
\value{
\itemize{
  \item \code{frechet_mean}: a list with the marginal Fréchet means
   (\code{mu}), variances (\code{var}), and standard deviations (\code{sd}).
  \item \code{frechet_ss}: a list with the Fréchet variances (\code{var})
  and the cumulative proportion of total variance explained (\code{var_exp}).
}
}
\description{
Computes the Fréchet mean, variance, and standard deviation of
a sample on the \eqn{d}-torus \eqn{[-l, l)^d}, \eqn{d\geq 1}, with
\eqn{-l \equiv l} identified.
}
\examples{
## Circular data

# Sample from a wrapped normal
x <- sdetorus::toPiInt(rnorm(n = 5e2, mean = 2, sd = 1))
frechet_mean(x = x)

# Sample from a bimodal distribution
x <- sdetorus::toPiInt(rnorm(n = 5e2, mean = c(1, -2), sd = c(0.5, 0.75)))
frechet_mean(x = x)

# Periodic data in [-2, 2)
x <- sdetorus::toInt(rnorm(n = 5e2, mean = c(-2, 1), sd = 2:1),
                     a = -2, b = 2)
frechet_mean(x = x, l = 2)

## Toroidal data

# Sample from a multivariate wrapped normal
n <- 50
S <- rbind(c(2.5, -0.2, 0.5),
           c(-0.2, 1.5, -0.5),
           c(0.5, -0.5, 0.75))
x <- sdetorus::toPiInt(mvtnorm::rmvnorm(n, mean = c(0, 1.5, -2), sigma = S))
(f <- frechet_mean(x = x))

# Total Fréchet variance is sum of marginal variances
sum(torus_dist(x, y = f$mu, squared = TRUE)) / n
sum(f$var)

# Cumulative proportion of variances
frechet_ss(x)
}
