## ----message=FALSE------------------------------------------------------------
# Load core libraries; install these packages if you have not already
library(ridigbio)
library(tidyverse)

# Load library for making nice HTML output
library(kableExtra)

## -----------------------------------------------------------------------------
# Edit the fields (e.g. `flags` or `institutioncode`) and values (e.g. 
# "rev_geocode_flip" or "fmnh") in `list()` to adjust your query and the fields
# (e.g. `uuid`) in `fields` to adjust the columns returned in your results
records <- idig_search_records(rq = list(flags = "rev_geocode_flip",
                                              institutioncode = "fmnh"),
                    fields = c("uuid",
                               "institutioncode",
                               "collectioncode",
                               "country",
                               "data.dwc:country",
                               "stateprovince",
                               "county",
                               "locality",
                               "geopoint",
                               "data.dwc:decimalLongitude",
                               "data.dwc:decimalLatitude"),
                    limit = 100000) %>% 
  # Rename fields to more easily reflect their provenance (either from the
  # data provider directly or modified by the data aggregator)
  rename(provider_lon = `data.dwc:decimalLongitude`,
         provider_lat = `data.dwc:decimalLatitude`,
         provider_country = `data.dwc:country`,
         aggregator_lon = `geopoint.lon`,
         aggregator_lat = `geopoint.lat`,
         aggregator_country = country,
         aggregator_stateprovince = stateprovince,
         aggregator_county = county,
         aggregator_locality = locality) %>% 
  # Reorder columns for easier viewing
  select(uuid, institutioncode, collectioncode, provider_lat, aggregator_lat,
         provider_lon, aggregator_lon, provider_country, aggregator_country,
         aggregator_stateprovince, aggregator_county, aggregator_locality)

## ----echo = FALSE-------------------------------------------------------------
# Subset `records` to show example
records[1:50,] %>% 
  kable() %>% 
  kable_styling(bootstrap_options = c("striped", "hover", "condensed"),
                font_size = 12,
                fixed_thead = T) %>% 
  scroll_box(width = "100%", height = "400px")

## ----eval=FALSE, include=TRUE-------------------------------------------------
#  # Save `records` as a CSV for reintegration into a local collection management
#  # system
#  write_csv(records, "records.csv")

