% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rintcal.R
\name{mix.ccurves}
\alias{mix.ccurves}
\title{Build a custom-made, mixed calibration curve.}
\usage{
mix.ccurves(
  proportion = 0.5,
  cc1 = "IntCal20",
  cc2 = "Marine20",
  name = "mixed.14C",
  cc.dir = c(),
  save = FALSE,
  offset = cbind(0, 0),
  sep = "\\t"
)
}
\arguments{
\item{proportion}{Proportion of the first calibration curve required. e.g., change to \code{proportion=0.7} if \code{cc1} should contribute 70\% (and \code{cc2} 30\%) to the mixed curve.}

\item{cc1}{The first calibration curve to be mixed. Defaults to the northern hemisphere terrestrial curve IntCal20.}

\item{cc2}{The second calibration curve to be mixed. Defaults to the marine curve IntCal20.}

\item{name}{Name of the new calibration curve.}

\item{cc.dir}{Name of the directory where to save the file. Since R does not allow automatic saving of files, this points to a temporary directory by default. Adapt to your own folder, e.g., \code{cc.dir="~/ccurves"} or in your current working directory, \code{cc.dir="."}.}

\item{save}{Save the curve in the folder specified by dir. Defaults to FALSE.}

\item{offset}{Any offset and error to be applied to \code{cc2} (default 0 +- 0). Entered as two columns (possibly of just one row).}

\item{sep}{Separator between fields (tab by default, "\\t")}
}
\value{
A file containing the custom-made calibration curve, based on calibration curves \code{cc1} and \code{cc2}.
}
\description{
If two curves need to be `mixed' to calibrate, e.g. for dates of mixed terrestrial and marine carbon sources, then this function can be used. The curve will be returned invisibly, or saved in a temporary directory together with the main calibration curves. This temporary directory then has to be specified in further commands, e.g. for rbacon: \code{Bacon(, cc.dir=tmpdr)} (see examples). It is advisable to make your own curves folder and have cc.dir point to that folder.
}
\details{
The proportional contribution of each of both calibration curves has to be set.
}
\examples{
tmpdir <- tempdir()
mix.ccurves(cc.dir=tmpdir)
# now assume the offset is constant but its uncertainty increases over time:
cc <- ccurve()
offset <- cbind(rep(100, nrow(cc)),  seq(0, 1e3, length=nrow(cc)))
# clean up:
unlink(tmpdir)
}
