% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.ate.R
\name{autoplot.ate}
\alias{autoplot.ate}
\title{Plot Average Risks}
\usage{
\method{autoplot}{ate}(object, ci = FALSE, band = FALSE, plot = TRUE,
  digits = 2, alpha = NA, ...)
}
\arguments{
\item{object}{Object obtained with the function \code{ate}.}

\item{ci}{[logical] If \code{TRUE} display the confidence intervals for the average risks.}

\item{band}{[logical] If \code{TRUE} display the confidence bands for the average risks.}

\item{plot}{[logical] Should the graphic be plotted.}

\item{digits}{[integer, >0] Number of decimal places.}

\item{alpha}{[numeric, 0-1] Transparency of the confidence bands. Argument passed to \code{ggplot2::geom_ribbon}.}

\item{...}{not used. Only for compatibility with the plot method.}
}
\description{
Plot average risks.
}
\examples{
\dontrun{
library(survival)
library(rms)

#### simulate data ####
n <- 1e2
set.seed(10)
dtS <- sampleData(n,outcome="survival")


#### Cox model ####
fit <- cph(formula = Surv(time,event)~ X1+X2,data=dtS,y=TRUE,x=TRUE)

#### Average treatment effect ####
seqTimes <- sort(unique(fit$y[,1]))
seqTimes5 <- seqTimes[seqTimes>5 & seqTimes<10]
ateFit <- ate(fit, data = dtS, treatment = "X1", contrasts = NULL,
              times = seqTimes, B = 0, band = TRUE, nsim.band = 500, y = TRUE,
              mc.cores=1)

#### display #### 
autoplot(ateFit)

outGG <- autoplot(ateFit, band = TRUE, ci = TRUE, alpha = 0.1)
dd <- as.data.frame(outGG$data[Treatment == 0])
outGG$plot + facet_wrap(~Treatment, labeller = label_both)
}
}
\seealso{
\code{\link{ate}} to compute average risks.
}
