#' Breast tissue biopsy data
#'
#' The Breast Cancer Wisconsin dataset from the UCI machine learning repository
#' records the measurements from breast tissue biopsies. The outcome of interest
#' is whether the sample was benign or malignant.
#'
#' @format ## `breastcancer`
#' A data frame with 683 rows and 10 columns:
#' \describe{
#'   \item{Benign}{1 for malignant, 0 for benign}
#'   \item{ClumpThickness}{Clump thickness on an integer scale from 1 to 10}
#'   \item{UniformityOfCellSize}{Uniformity of cell size on an integer scale from 1 to 10}
#'   \item{UniformityofCellShape}{Uniformity of cell shape on an integer scale from 1 to 10}
#'   \item{MarginalAdhesion}{Marginal adhesion on an integer scale from 1 to 10}
#'   \item{SingleEpithelialCellSize}{Single epithelial cell size on an integer scale from 1 to 10}
#'   \item{BareNuclei}{Bare nuclei on an integer scale from 1 to 10}
#'   \item{BlandChromatin}{Bland chromatin on an integer scale from 1 to 10}
#'   \item{NormalNucleoli}{Normal nucleoli on an integer scale from 1 to 10}
#'   \item{Mitosis}{Mitosis on an integer scale from 1 to 10}
#' }
#' @source <https://archive.ics.uci.edu/dataset/15/breast+cancer+wisconsin+original>
"breastcancer"
