% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{cv_risk_mod_random_start}
\alias{cv_risk_mod_random_start}
\title{Run Cross-Validation to Tune Lambda0 with Random Start}
\usage{
cv_risk_mod_random_start(
  X,
  y,
  weights = NULL,
  a = -10,
  b = 10,
  max_iters = 100,
  tol = 1e-05,
  nlambda = 25,
  lambda_min_ratio = ifelse(nrow(X) < ncol(X), 0.01, 1e-04),
  lambda0 = NULL,
  nfolds = 10,
  foldids = NULL,
  parallel = FALSE,
  seed = NULL,
  nstart = 5
)
}
\arguments{
\item{X}{Input covariate matrix with dimension \eqn{n \times p};
every row is an observation.}

\item{y}{Numeric vector for the (binomial) response variable.}

\item{weights}{Numeric vector of length \eqn{n} with weights for each
observation. Unless otherwise specified, default will give equal weight to
each observation.}

\item{a}{Integer lower bound for coefficients (default: -10).}

\item{b}{Integer upper bound for coefficients (default: 10).}

\item{max_iters}{Maximum number of iterations (default: 100).}

\item{tol}{Tolerance for convergence (default: 1e-5).}

\item{nlambda}{Number of lambda values to try (default: 25).}

\item{lambda_min_ratio}{Smallest value for lambda, as a fraction of
lambda_max (the smallest value for which all coefficients are zero).
The default depends on the sample size (\eqn{n}) relative to the number of
variables (\eqn{p}). If \eqn{n > p}, the default is 0.0001, close to zero.
If \eqn{n < p}, the default is 0.01.}

\item{lambda0}{Optional sequence of lambda values. By default, the function
will derive the lambda0 sequence based on the data (see \code{lambda_min_ratio}).}

\item{nfolds}{Number of folds, implied if \code{foldids} provided (default: 10).}

\item{foldids}{Optional vector of values between 1 and \code{nfolds}.}

\item{parallel}{If \code{TRUE}, parallel processing (using \link{foreach}) is implemented
during cross-validation to increase efficiency (default: \code{FALSE}).
User must first register parallel backend with a function such as
\link[doParallel:registerDoParallel]{doParallel::registerDoParallel}.}

\item{seed}{An integer that is used as argument by \code{set.seed()} for
offsetting the random number generator. Default is to not set a
particular randomization seed.}

\item{nstart}{Number of different random starts to try
(default: 5).}
}
\description{
Runs k-fold cross-validation on a grid of \eqn{\lambda_0} values
using random warm starts (see \link{risk_mod_random_start}. Records
class accuracy and deviance for each \eqn{\lambda_0}. Returns an
object of class "cv_risk_mod".
}
