% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detectbraiding.R
\name{routelist}
\alias{routelist}
\title{Detect Multiple Routes}
\usage{
routelist(startseg, endseg, rivers, reps = 100)
}
\arguments{
\item{startseg}{Segment number of the start of the route}

\item{endseg}{Segment number of the end of the route}

\item{rivers}{The river network object to use}

\item{reps}{Deprecated.  Was used in a previous version using randomization.}
}
\value{
A list of vectors, each describing a route in segment numbers.
}
\description{
Called internally within \link{riverdistancelist}.  Detects all possible routes from one river network segment to another, in the event
  of braiding.
}
\note{
The previous version of this function returned many possible routes using randomization - this algorithm now computes all possible routes.
}
\examples{
data(KilleyW)
plot(x=KilleyW)

routelist(startseg=1, endseg=16, rivers=KilleyW, reps=1000)
}
\author{
Matt Tyers
}

