% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/RiverTM.R
\name{RiverTM}
\alias{RiverTM}
\title{Tick Marks on River Charts}
\usage{
RiverTM(tickmark, value, riverlayout, range = NA, side = "L", pos = 1,
  tm.l = 1, tm.col = "black", lbl.shw = TRUE, lbl.col = "black",
  lbl.cex = 0.7, lbl.row = TRUE, label = NA)
}
\arguments{
\item{tickmark}{a vector of tick mark values.}

\item{value}{the variables which the tick marks are for.}

\item{riverlayout}{the output list of \code{RiverLayout} or \code{RiverMap}.}

\item{range}{bar-chart value range. A vector of two values indicating lower
limit and upper limit.}

\item{side}{position of tick marks. \code{"l"} for left and \code{"r"} for
right.}

\item{pos}{position of tick marks. \code{-1} for in and \code{1} for out.}

\item{tm.l}{tick mark length.}

\item{tm.col}{tick mark colour.}

\item{lbl.shw}{show labels of tick marks (\code{TRUE}) or not
(\code{FALSE}).}

\item{lbl.col}{label colour.}

\item{lbl.cex}{label size.}

\item{lbl.row}{show one label per row (\code{TRUE}) or not (\code{FALSE}).}

\item{label}{a vector of tick mark labels.}
}
\description{
This adds tick marks to the river chart.
}
\examples{
data(Ballinderry)

riverlayout <- RiverLayout(B.river$River,B.river$Length,
                           B.river$Parent,B.river$Position,
                           B.river$Distance, direction = -1)
RiverDraw(riverlayout)

RiverPoint(NA,B.elevation$River, B.elevation$Distance,
           B.elevation$Elevation, riverlayout)

RiverTM(c(0, 100, 200, 300, 400, 500), B.elevation[3], riverlayout,
        pos=-1, side = "R", range = c(0,500),
        label = c(0, 100, 200, 300, 400, 500))
}
\author{
Feng Mao
}
\seealso{
\code{\link{RiverLayout}}, \code{\link{RiverDraw}},
\code{\link{RiverMap}}.  \code{\link{par}}.
}
\keyword{hplot}

