# This file was generated by Rcpp::compileAttributes
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title Froude Number
#' @description Calculate the Froude Number.
#' @param Q Flow rate [\eqn{L^3 T^{-1}}].
#' @param g Gravitational acceleration [\eqn{L T^{-2}}].
#' @param A Flow area [\eqn{L^2}].
#' @param DH Hydraulic depth [\eqn{L}].
#' @return The Froude Number (dimensionless).
#' @details The Froude number is a dimensionless measure of bulk flow 
#'   characteristics that represents the relative importance of inertial 
#'   forces and gravitational forces. For open channel flow, the Froude 
#'   number of open channel flow is defined as \deqn{Fr = \frac{v}{\sqrt{gD_H}}}, 
#'   where \eqn{v = \frac{Q}{A}} is the flow velocity, \eqn{g} is the gravitational 
#'   acceleration and \eqn{D_H} is the hydraulic depth. The Froude number is related
#'   to the energy state of the flow and can be used to identify flows as
#'   either supercritical (\eqn{Fr < 1}) or subcritical (\eqn{Fr > 1}).
#' @examples
#' froude(250, 32.2, 171, 1.71) # subcritical flow
#' froude(250, 32.2, 57.9, 0.579) # critical flow
#' froude(250, 32.2, 45, 0.45) # supercritical flow
#' @export
froude <- function(Q, g, A, DH) {
    .Call('rivr_froude', PACKAGE = 'rivr', Q, g, A, DH)
}

#' @title Channel geometry
#' @description Compute geometry relations for trapezoidal channels.
#' @param y Flow depth [\eqn{L}].
#' @param B Channel bottom width [\eqn{L}].
#' @param SS Channel sideslope [\eqn{L L^{-1}}]. For a rectangular channel, \code{SS = 0}.
#' @return Named vector:
#'   \item{A}{Flow area [\eqn{L^2}].}
#'   \item{P}{Wetted perimeter [\eqn{L}].}
#'   \item{R}{Hydraulic radius [\eqn{L}].}
#'   \item{dAdy}{Water surface width [\eqn{L}].}
#'   \item{dPdy}{First derivative of wetted perimeter w.r.t. flow depth.}
#'   \item{dRdy}{First derivative of hydraulic radius w.r.t. flow depth.}
#'   \item{DH}{Hydraulic depth [\eqn{L}].}
#'   \item{ybar}{Vertical distance from water surface to centroid of flow area [\eqn{L}].}
#' @details Channel geometry relations are routinely calculated in numerical solutions of steady, 
#'   gradually-varied and unsteady flows. This function is used extensively by internal 
#'   procedures and is made accessible to the user for convenience.
#' @examples
#' channel_geom(1.71, 100, 0) # rectangular channel
#' channel_geom(5.79, 6.1, 1.5) # trapezoidal channel with sideslope 3H:2V
#' @export
channel_geom <- function(y, B, SS) {
    .Call('rivr_channel_geom', PACKAGE = 'rivr', y, B, SS)
}

#' @title Channel conveyance
#' @description Calculate the channel conveyance.
#' @param n Manning's roughness coefficient (dimensionless).
#' @param A Flow area [\eqn{L^2}].
#' @param R Hydraulic radius [\eqn{L}].
#' @param Cm Unit conversion coefficient for Manning's equation. For SI units, Cm = 1.
#' @return The channel conveyance.
#' @details Channel conveyance is routinely calculated in numerical solutions of steady, 
#'   gradually-varied and unsteady flows. This function is used extensively by internal 
#'   procedures and is made accessible to the user for convenience.
#' @export
conveyance <- function(n, A, R, Cm) {
    .Call('rivr_conveyance', PACKAGE = 'rivr', n, A, R, Cm)
}

#' @title Normal depth
#' @description Calculate the normal (equilibrium) depth using Manning's equation.
#' @param So Channel slope [\eqn{L L^{-1}}].
#' @param n Manning's roughness coefficient.
#' @param Q Flow rate [\eqn{L^3 T^{-1}}].
#' @param yopt Initial guess for normal depth [\eqn{L}].
#' @param Cm Unit conversion coefficient for Manning's equation. For SI units, Cm = 1.
#' @param B Channel bottom width [\eqn{L}].
#' @param SS Channel sideslope [\eqn{L L^{-1}}].
#' @return The normal depth \eqn{y_n} [\eqn{L}].
#' @details The normal depth is the equilibrium depth of a channel for a given 
#'   flow rate, channel slope, geometry and roughness.
#'   Manning's equation is used to calculate the equilibrium depth. Manning's 
#'   equation for normal flow is defined as \deqn{Q = \frac{C_m}{n} AR^{2/3}S_0^{1/2}}
#'   where \eqn{Q} is the channel flow, \eqn{S_0} is the channel slope, \eqn{A} is the 
#'   cross-sectional flow area, \eqn{R} is the hydraulic depth and \eqn{C_m} is a conversion factor
#'   based on the unit system used. This function uses a Newton-Raphson root-finding approach 
#'   to calculate the normal depth, i.e.
#'   \eqn{y = y_n} when \deqn{f(y) = \frac{A^{5/3}}{P^{2/3}} - \frac{nQ}{C_mS_0^{1/2}} = 0}.
#' @examples
#' normal_depth(0.001, 0.045, 250, 3, 1.486, 100, 0) # rectangular channel
#' normal_depth(0.0008, 0.013, 126, 5, 1, 6.1, 1.5) # trapezoidal channel with sideslope 3H:2V
#' @export
normal_depth <- function(So, n, Q, yopt, Cm, B, SS) {
    .Call('rivr_normal_depth', PACKAGE = 'rivr', So, n, Q, yopt, Cm, B, SS)
}

#' @title Critical depth
#' @description Calculate the critical depth.
#' @details The critical depth is the water depth at which a channel 
#'   flow regime will transition from supercritical to subcritical (or vice versa).
#'   Calculation of the critical depth is based on a specific energy formulation, 
#'   i.e. \deqn{E = y + z + \frac{Q^2}{2gB^2y^2}} where \eqn{y} is the flow depth, \eqn{z} is 
#'   the elevation relative to some datum (assumed to be 0), and the last term 
#'   represents kinetic energy. More specifically, the function operates
#'   by finding the point where the derivative of specific energy w.r.t. \eqn{y} is zero, i.e.
#'   \eqn{y = y_c} when \deqn{\frac{dE}{dy} = 1 - \frac{Q^2}{gA^3}\frac{dA}{dy} = 0}.
#' @param Q Flow rate [\eqn{L^3 T^{-1}}].
#' @param yopt Initial guess for normal depth [\eqn{L}].
#' @param g Gravitational acceleration [\eqn{L T^{-2}}].
#' @param B Channel bottom width [\eqn{L}].
#' @param SS Channel sideslope [\eqn{L L^{-1}}].
#' @return The critical depth \eqn{y_c} [\eqn{L}].
#' @examples
#' critical_depth(250, 2, 32.2, 100, 0) # rectangular channel
#' critical_depth(126, 1, 9.81, 6.1, 1.5) # trapezoidal channel with sideslope 3H:2V
#' @export
critical_depth <- function(Q, yopt, g, B, SS) {
    .Call('rivr_critical_depth', PACKAGE = 'rivr', Q, yopt, g, B, SS)
}

loop_step <- function(So, n, Q, Cm, g, y, B, SS, z, x, stepdist, totaldist) {
    .Call('rivr_loop_step', PACKAGE = 'rivr', So, n, Q, Cm, g, y, B, SS, z, x, stepdist, totaldist)
}

kinematic_wave <- function(So, n, Cm, g, B, SS, numnodes, bc, ic, timestep, spacestep, mpidx, mtidx) {
    .Call('rivr_kinematic_wave', PACKAGE = 'rivr', So, n, Cm, g, B, SS, numnodes, bc, ic, timestep, spacestep, mpidx, mtidx)
}

characteristic_wave <- function(So, n, Cm, g, B, SS, numnodes, bc, dc, ic, timestep, spacestep, mpidx, mtidx, btype) {
    .Call('rivr_characteristic_wave', PACKAGE = 'rivr', So, n, Cm, g, B, SS, numnodes, bc, dc, ic, timestep, spacestep, mpidx, mtidx, btype)
}

diffusive_wave <- function(So, n, Cm, g, B, SS, numnodes, bc, dc, ic, timestep, spacestep, mpidx, mtidx, btype) {
    .Call('rivr_diffusive_wave', PACKAGE = 'rivr', So, n, Cm, g, B, SS, numnodes, bc, dc, ic, timestep, spacestep, mpidx, mtidx, btype)
}

