% Generated by roxygen2 (4.0.2): do not edit by hand
\name{fromJSONstat}
\alias{fromJSONstat}
\title{Convert JSON-stat format to data frame(s)}
\usage{
fromJSONstat(x, naming = "label", use_factors = FALSE)
}
\arguments{
\item{x}{the JSON-stat format in characters (or R list equivalent)}

\item{naming}{whether to use (longer) \code{label}s or (shorter) \code{id}s}

\item{use_factors}{whether dimension categories should be factors or
  character objects}
}
\description{
This function takes characters of a JSON-stat format response (or the
corresponding R list equivalent) and returns a list of data frames with
columns for each dimension and one \code{value} column.
}
\examples{
\dontrun{
oecd.canada.url <- "http://json-stat.org/samples/oecd-canada.json"
results <- fromJSONstat(readLines(oecd.canada.url))
names(results)
}
}

