% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expr-lang.R
\name{lang_name}
\alias{lang_name}
\title{Extract function name of a call}
\usage{
lang_name(lang)
}
\arguments{
\item{lang}{Can be a call (language object), a formula quoting a
call in the right-hand side, or a frame object from which to
extract the call expression.}
}
\value{
A string with the function name, or \code{NULL} if the function
is anonymous.
}
\description{
Extract function name of a call
}
\examples{
# Extract the function name from quoted calls:
lang_name(~foo(bar))
lang_name(quote(foo(bar)))

# Or from a frame:
foo <- function(bar) lang_name(call_frame())
foo(bar)

# Namespaced calls are correctly handled:
lang_name(~base::matrix(baz))

# Anonymous and subsetted functions return NULL:
lang_name(~foo$bar())
lang_name(~foo[[bar]]())
lang_name(~foo()())
}
\seealso{
\code{\link[=lang_fn]{lang_fn()}}
}
