% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expr-lang.R
\name{lang}
\alias{lang}
\alias{new_language}
\title{Create a call}
\usage{
lang(.fn, ..., .ns = NULL)

new_language(head, tail = NULL)
}
\arguments{
\item{.fn}{Function to call. Must be a callable object: a string,
symbol, call, or a function.}

\item{...}{Arguments to the call either in or out of a list. Dots
are evaluated with \link[=dots_list]{explicit splicing}.}

\item{.ns}{Namespace with which to prefix \code{.fn}. Must be a string
or symbol.}

\item{head}{A \link[=is_callable]{callable} object: a symbol, call, or
literal function.}

\item{tail}{A \link{pairlist} of arguments.}
}
\description{
Language objects are (with symbols) one of the two types of
\link[=is_symbolic]{symbolic} objects in R. These symbolic objects form
the backbone of \link[=is_expr]{expressions}. They represent a value,
unlike literal objects which are their own values. While symbols
are directly \link[=env_bind]{bound} to a value, language objects
represent \emph{function calls}, which is why they are commonly referred
to as calls.
\itemize{
\item \code{lang()} creates a call from a function name (or a literal
function to inline in the call) and a list of arguments.
\item \code{new_language()} is bare-bones and takes a head and a tail. The
head must be \link[=is_callable]{callable} and the tail must be a
\link{pairlist}. See section on calls as parse trees below. This
constructor is useful to avoid costly coercions between lists and
pairlists of arguments.
}
}
\section{Calls as parse tree}{


Language objects are structurally identical to
\link[=pairlist]{pairlists}. They are containers of two objects, the head
and the tail (also called the CAR and the CDR).
\itemize{
\item The head contains the function to call, either literally or
symbolically. If a literal function, the call is said to be
inlined. If a symbol, the call is named. If another call, it is
recursive. \code{foo()()} would be an example of a recursive call
whose head contains another call. See \code{\link[=lang_type_of]{lang_type_of()}} and
\code{\link[=is_callable]{is_callable()}}.
\item The tail contains the arguments and must be a \link{pairlist}.
}

You can retrieve those components with \code{\link[=lang_head]{lang_head()}} and
\code{\link[=lang_tail]{lang_tail()}}. Since language nodes can contain other nodes (either
calls or pairlists), they are capable of forming a tree. When R
\link[=parse_expr]{parses} an expression, it saves the parse tree in a
data structure composed of language and pairlist nodes. It is
precisely because the parse tree is saved in first-class R objects
that it is possible for functions to \link[=expr]{capture} their
arguments unevaluated.
}

\section{Call versus language}{


\code{call} is the old S \link[base:mode]{mode} of these objects while
\code{language} is the R \link[base:typeof]{type}. While it is usually
better to avoid using S terminology, it would probably be even more
confusing to systematically refer to "calls" as "language". rlang
still uses \code{lang} as particle for function dealing with calls for
consistency.
}

\examples{
# fn can either be a string, a symbol or a call
lang("f", a = 1)
lang(quote(f), a = 1)
lang(quote(f()), a = 1)

#' Can supply arguments individually or in a list
lang(quote(f), a = 1, b = 2)
lang(quote(f), splice(list(a = 1, b = 2)))

# Creating namespaced calls:
lang("fun", arg = quote(baz), .ns = "mypkg")
}
\seealso{
lang_modify
}
