% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vector-ctor.R
\name{vector-along}
\alias{vector-along}
\alias{lgl_along}
\alias{int_along}
\alias{dbl_along}
\alias{chr_along}
\alias{cpl_along}
\alias{raw_along}
\alias{bytes_along}
\alias{list_along}
\alias{rep_along}
\title{Create vectors matching the length of a given vector}
\usage{
lgl_along(.x)

int_along(.x)

dbl_along(.x)

chr_along(.x)

cpl_along(.x)

raw_along(.x)

bytes_along(.x)

list_along(.x)

rep_along(.x, .y)
}
\arguments{
\item{.x}{A vector.}

\item{.y}{Values to repeat.}
}
\description{
These functions take the idea of \code{\link[=seq_along]{seq_along()}} and generalise it to
creating lists (\code{list_along}) and repeating values (\code{rep_along}).
Except for \code{list_along()} and \code{raw_along()}, the empty vectors are
filled with typed \code{missing} values.
}
\examples{
x <- 0:5
rep_along(x, 1:2)
rep_along(x, 1)
list_along(x)
}
\seealso{
vector-len
}
