% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expr-lang.R
\name{lang_head}
\alias{lang_head}
\alias{lang_tail}
\title{Return the head or tail of a call object}
\usage{
lang_head(lang)

lang_tail(lang)
}
\arguments{
\item{lang}{Can be a call (language object), a formula quoting a
call in the right-hand side, or a frame object from which to
extract the call expression.}
}
\description{
These functions return the head or the tail of a call. See section
on calls as parse trees in \code{\link[=lang]{lang()}}. They are equivalent to
\code{\link[=node_car]{node_car()}} and \code{\link[=node_cdr]{node_cdr()}} but support quosures and check that
the input is indeed a call before retrieving the head or tail (it
is unsafe to do this without type checking).

\code{lang_head()} returns the head of the call without any conversion,
unlike \code{\link[=lang_name]{lang_name()}} which checks that the head is a symbol and
converts it to a string. \code{lang_tail()} returns the pairlist of
arguments (while \code{\link[=lang_args]{lang_args()}} returns the same object converted to
a regular list)
}
\examples{
lang <- quote(foo(bar, baz))
lang_head(lang)
lang_tail(lang)
}
\seealso{
\link{pairlist}, \code{\link[=lang_args]{lang_args()}}, \code{\link[=lang]{lang()}}
}
