% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/call.R
\name{call_fn}
\alias{call_fn}
\title{Extract function from a call}
\usage{
call_fn(call, env = caller_env())
}
\arguments{
\item{call}{Can be a call or a quosure that wraps a call.}

\item{env}{The environment where to find the definition of the
function quoted in \code{call} in case \code{call} is not wrapped in a
quosure.}
}
\description{
If a frame or formula, the function will be retrieved from the
associated environment. Otherwise, it is looked up in the calling
frame.
}
\section{Life cycle}{


In rlang 0.2.0, \code{lang_fn()} was soft-deprecated and renamed to
\code{call_fn()}. See lifecycle section in \code{\link[=call2]{call2()}} for more about this
change.
}

\examples{
# Extract from a quoted call:
call_fn(quote(matrix()))
call_fn(quo(matrix()))

# Extract the calling function
test <- function() call_fn(call_frame())
test()
}
\seealso{
\code{\link[=call_name]{call_name()}}
}
