% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{Connectivity-Algorithms-1}
\alias{Connectivity-Algorithms-1}
\alias{IsConnectedRunner}
\alias{IsAcyclicRunner}
\alias{IsTreeRunner}
\alias{IsBipartiteRunner}
\alias{IsStronglyConnectedRunner}
\alias{IsDAGRunner}
\alias{IsBiNodeConnectedRunner}
\alias{IsBiEdgeConnectedRunner}
\alias{IsLoopFreeRunner}
\alias{IsParallelFreeRunner}
\alias{IsSimpleGraphRunner}
\alias{IsEulerianRunner}
\title{Connectivity Algorithms - Boolean Return}
\usage{
IsConnectedRunner(arcSources, arcTargets, numNodes)

IsAcyclicRunner(arcSources, arcTargets, numNodes)

IsTreeRunner(arcSources, arcTargets, numNodes)

IsBipartiteRunner(arcSources, arcTargets, numNodes)

IsStronglyConnectedRunner(arcSources, arcTargets, numNodes)

IsDAGRunner(arcSources, arcTargets, numNodes)

IsBiNodeConnectedRunner(arcSources, arcTargets, numNodes)

IsBiEdgeConnectedRunner(arcSources, arcTargets, numNodes)

IsLoopFreeRunner(arcSources, arcTargets, numNodes)

IsParallelFreeRunner(arcSources, arcTargets, numNodes)

IsSimpleGraphRunner(arcSources, arcTargets, numNodes)

IsEulerianRunner(arcSources, arcTargets, numNodes)
}
\arguments{
\item{arcSources, }{a vector corresponding to the source nodes of a graph's edges}

\item{arcTargets, }{a vector corresponding to the destination nodes of a graph's edges}

\item{numNodes, }{the number of nodes in the graph}
}
\value{
a boolean, stating if a graph has some property
}
\description{
`IsConnected` returns if a graph is connected or not

`IsAcyclic` returns if a graph is acyclic or not

`IsTree` returns if a graph is a tree or not

`IsBipartite` returns if a graph is bipartite or not

`IsStronglyConnected` returns if a graph is strongly connected or not

`IsDAG` returns if a graph is a DAG or not

`IsBiNodeConnected` returns if a graph is bi-node connected or not

`IsBiEdgeConnected` returns if a graph is bi-edge connected or not

`IsLoopFree` returns if a graph is loop-free or not

`IsParallelFree` returns if a graph is parallel-free or not

`IsSimpleGraph` returns if a graph is simple or not

`IsEulerian` returns if a graph is Eulerian or not
}
\examples{
data(small_graph_example)
start <- small_graph_example$startnodes
end <- small_graph_example$endnodes
numnodes <- length(unique(c(start, end)))
IsConnected(start, end, numnodes)
}
