% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rliger.R
\name{makeRiverplot}
\alias{makeRiverplot}
\title{Generate a river (Sankey) plot}
\usage{
makeRiverplot(
  object,
  cluster1,
  cluster2,
  cluster_consensus = NULL,
  min.frac = 0.05,
  min.cells = 10,
  river.yscale = 1,
  river.lty = 0,
  river.node_margin = 0.1,
  label.cex = 1,
  label.col = "black",
  lab.srt = 0,
  river.usr = NULL,
  node.order = "auto"
)
}
\arguments{
\item{object}{\code{liger} object. Should run quantileAlignSNF before calling.}

\item{cluster1}{Cluster assignments for dataset 1. Note that cluster names should be distinct
across datasets.}

\item{cluster2}{Cluster assignments for dataset 2. Note that cluster names should be distinct
across datasets.}

\item{cluster_consensus}{Optional external consensus clustering (to use instead of object
clusters)}

\item{min.frac}{Minimum fraction of cluster for edge to be shown (default 0.05).}

\item{min.cells}{Minumum number of cells for edge to be shown (default 10).}

\item{river.yscale}{y-scale to pass to riverplot -- scales the edge with values by this factor,
can be used to squeeze vertically (default 1).}

\item{river.lty}{Line style to pass to riverplot (default 0).}

\item{river.node_margin}{Node_margin to pass to riverplot -- how much vertical space to keep
between the nodes (default 0.1).}

\item{label.cex}{Size of text labels (default 1).}

\item{label.col}{Color of text labels (defualt "black").}

\item{lab.srt}{Angle of text labels (default 0).}

\item{river.usr}{Coordinates at which to draw the plot in form (x0, x1, y0, y1).}

\item{node.order}{Order of clusters in each set (list with three vectors of ordinal numbers).
By default will try to automatically order them appropriately.}
}
\value{
A riverplot object
}
\description{
Creates a riverplot to show how separate cluster assignments from two datasets map onto a
joint clustering. The joint clustering is by default the object clustering, but an external one
can also be passed in. Uses the riverplot package to construct riverplot object and then plot.
}
\examples{
\dontrun{
# ligerex (liger object), factorization complete input
# toy clusters
cluster1 <- sample(c('type1', 'type2', 'type3'), ncol(ligerex@raw.data[[1]]), replace = TRUE)
names(cluster1) <- colnames(ligerex@raw.data[[1]])
cluster2 <- sample(c('type4', 'type5', 'type6'), ncol(ligerex@raw.data[[2]]), replace = TRUE)
names(cluster2) <- colnames(ligerex@raw.data[[2]])
# create riverplot
makeRiverplot(ligerex, cluster1, cluster2)
}
}
