% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplotting.R
\name{plotCellViolin}
\alias{plotCellViolin}
\title{Generate violin/box plot(s) using liger object}
\usage{
plotCellViolin(
  object,
  y,
  groupBy = NULL,
  slot = c("cellMeta", "rawData", "normData", "scaleData", "H.norm", "H"),
  yFunc = NULL,
  cellIdx = NULL,
  colorBy = NULL,
  splitBy = NULL,
  titles = NULL,
  ...
)
}
\arguments{
\item{object}{\linkS4class{liger} object}

\item{y}{Available variable name in \code{slot} to look for the value to
visualize.}

\item{groupBy, colorBy}{Available variable name in \code{cellMeta} slot to
look for categorical grouping. See details. Default \code{NULL} produces no
grouping and all-black graphic elements.}

\item{slot}{Choose the slot to find the \code{y} variable. See Details.
Default \code{"cellMeta"}.}

\item{yFunc}{A function object that expects a vector/factor/data.frame
retrieved by \code{y} as the only input, and returns an object of the same
size, so that the y-axis is replaced by this output. Useful when, for
example, users need to scale the gene expression shown on plot.}

\item{cellIdx}{Character, logical or numeric index that can subscribe cells.
Missing or \code{NULL} for all cells.}

\item{splitBy}{Character vector of categorical variable names in
\code{cellMeta} slot. Split all cells by groupings on this/these variable(s)
to produce a violin plot containing only the cells in each group. Default
\code{NULL}.}

\item{titles}{Title text. A character scalar or a character vector with as
many elements as multiple plots are supposed to be generated. Default
\code{NULL}.}

\item{...}{More plot setting arguments. See \code{\link{.ggCellViolin}} and
\code{\link{.ggplotLigerTheme}}.}
}
\value{
A ggplot object when a single plot is intended. A list of ggplot
objects, when multiple \code{y} variables and/or \code{splitBy} are set. When
\code{plotly = TRUE}, all ggplot objects become plotly (htmlwidget) objects.
}
\description{
This function allows for using available cell metadata, feature
expression or factor loading to generate violin plot, and grouping the data
with available categorical cell metadata. Available categorical cell metadata
can be used to form the color annotation. When it is different from the
grouping, it forms a nested grouping. Multiple y-axis variables are allowed
from the same specification of \code{slot}, and this returns a list of violin
plot for each. Users can further split the plot(s) by grouping on cells (e.g.
datasets).
}
\details{
Available option for \code{slot} include: \code{"cellMeta"},
\code{"rawData"}, \code{"normData"}, \code{"scaleData"}, \code{"H.norm"}
and \code{"H"}. When \code{"rawData"}, \code{"normData"} or
\code{"scaleData"}, \code{y} has to be a character vector of feature names.
When \code{"H.norm"} or \code{"H"}, \code{colorBy} can be any valid index to
select one factor of interests. Note that character index follows
\code{"Factor_[k]"} format, with replacing \code{[k]} with an integer.

When \code{"cellMeta"}, \code{y} has to be an available column name in
the table. Note that, for \code{y} as well as \code{groupBy}, \code{colorBy}
and \code{splitBy} since a matrix object is feasible in \code{cellMeta}
table, using a column (e.g. named as \code{"column1"} in a certain matrix
(e.g. named as \code{"matrixVar"}) should follow the syntax of
\code{"matrixVar.column1"}. When the matrix does not have a "colname"
attribute, the subscription goes with \code{"matrixVar.V1"},
\code{"matrixVar.V2"} and etc. These are based on the nature of
\code{as.data.frame} method on a \code{\link[S4Vectors]{DataFrame}} object.

\code{groupBy} is basically send to \code{ggplot2::aes(x)}, while
\code{colorBy} is for the "colour" aesthetics. Specifying \code{colorBy}
without \code{groupBy} visually creates grouping but there will not be
varying values on the x-axis, so \code{boxWidth} will be forced to the same
value as \code{violinWidth} under this situation.
}
\examples{
plotCellViolin(pbmcPlot, y = "nUMI", groupBy = "dataset", slot = "cellMeta")
plotCellViolin(pbmcPlot, y = "nUMI", groupBy = "leiden_cluster",
               slot = "cellMeta", splitBy = "dataset",
               colorBy = "leiden_cluster",
               box = TRUE, dot = TRUE,
               ylab = "Total counts per cell",
               colorValues = RColorBrewer::brewer.pal(8, "Set1"))
plotCellViolin(pbmcPlot, y = "S100A8", slot = "normData",
               yFunc = function(x) log2(10000*x + 1),
               groupBy = "dataset", colorBy = "leiden_cluster",
               box = TRUE, ylab = "S100A8 Expression")
}
