% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lex.R
\name{lex}
\alias{lex}
\title{Build a lexer}
\usage{
lex(module = NA, args = list(), debug = FALSE, debuglog = NA,
  errorlog = NA)
}
\arguments{
\item{module}{R6 class containing lex rules}

\item{args}{list of arguments that should be passed to constructor}

\item{debug}{on and off debug mode}

\item{debuglog}{custom logger for debug messages}

\item{errorlog}{custom logger for error messages}
}
\value{
Lexer ready to use
}
\description{
Build all of the regular expression rules from definitions in the supplied module
}
\examples{
TOKENS = c('NAME', 'NUMBER')
LITERALS = c('=','+','-','*','/', '(',')')

Lexer <- R6::R6Class("Lexer",
  public = list(
    tokens = TOKENS,
    literals = LITERALS,
    t_NAME = '[a-zA-Z_][a-zA-Z0-9_]*',
    t_NUMBER = function(re='\\\\d+', t) {
      t$value <- strtoi(t$value)
      return(t)
    },
    t_ignore = " \\t",
    t_newline = function(re='\\\\n+', t) {
       t$lexer$lineno <- t$lexer$lineno + nchar(t$value)
       return(NULL)
    },
    t_error = function(t) {
      cat(sprintf("Illegal character '\%s'", t$value[1]))
      t$lexer$skip(1)
      return(t)
    }
  )
)

lexer  <- rly::lex(Lexer)
}

