% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geocode.R
\name{mz_geocode}
\alias{mz_geocode}
\title{Geocode an address or other location}
\usage{
mz_geocode(location, api_key = NULL)
}
\arguments{
\item{location}{An address or other suitably specific search string}

\item{api_key}{Your Mapzen API key, defaults to the value of the MAPZEN_KEY environment variable}
}
\value{
A tibble, with the parsed address used to retrieve the geocode, lat/lon,
and the confidence (between 0 and 1)
}
\description{
This is a convenience function that calls \code{\link{mz_search}} to retrieve
latitude and longitude.
}
\examples{
\dontrun{
mz_geocode("1600 Pennsylvania Ave., Washington DC")

# can also be a landmark
mz_geocode("Statue of Liberty, New York")
}

}
\seealso{
\code{\link{mz_search}}, \code{\link{mz_reverse_geocode}}
}
