/*
 * Decompiled with CFR 0.152.
 */
package dmLab.mcfs.mcfsEngine.framework;

import dmLab.array.FArray;
import dmLab.array.functions.DiscFunctions;
import dmLab.classifier.Classifier;
import dmLab.gui.chartPanel.ChartFrame;
import dmLab.gui.chartPanel.DataSeries;
import dmLab.mcfs.MCFSParams;
import dmLab.mcfs.attributesID.AttributesID;
import dmLab.mcfs.attributesRI.AttributesRI;
import dmLab.mcfs.attributesRI.Ranking;
import dmLab.mcfs.attributesRI.measuresRI.ADXRIMeasure;
import dmLab.mcfs.attributesRI.measuresRI.ClassifiersMeasure;
import dmLab.mcfs.attributesRI.measuresRI.ImportanceMeasure;
import dmLab.mcfs.attributesRI.measuresRI.J48RIMeasure;
import dmLab.mcfs.attributesRI.measuresRI.NodesMeasure;
import dmLab.mcfs.attributesRI.measuresRI.ProjectionMeasure;
import dmLab.mcfs.attributesRI.measuresRI.RINormMeasure;
import dmLab.mcfs.attributesRI.measuresRI.SliqRIMeasure;
import dmLab.mcfs.cutoffMethods.Cutoff;
import dmLab.utils.ArrayUtils;
import dmLab.utils.MathUtils;
import dmLab.utils.ProgressCounter;
import dmLab.utils.cmatrix.ConfusionMatrix;
import dmLab.utils.dataframe.DataFrame;
import dmLab.utils.list.FloatList;
import dmLab.utils.statFunctions.LinearRegression;
import dmLab.utils.statList.StatsList;
import java.awt.HeadlessException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;

public final class GlobalStats {
    private ConfusionMatrix confusionMatrix;
    private ChartFrame distanceChart = null;
    private LinearRegression myLinearRegression;
    private AttributesRI[] attrRI;
    private AttributesID attrID;
    private StatsList splitsStats;
    private Cutoff cutoff;
    private MCFSParams myMCFSParams;
    private FloatList distanceList = new FloatList();
    private FloatList commonPartList = new FloatList();
    private FloatList mAvgList = new FloatList();
    private FloatList betaList = new FloatList();
    private FloatList projectionIdxList = new FloatList();
    private Ranking oldRank = null;
    private Ranking newRank = null;
    private int projectionsCounter = 0;
    private int calculatedDistances = 0;
    private float[] xArray;
    private String prefix;
    private ProgressCounter pc;
    public String[] attrNames;
    private static int WINDOW_SIZE = 20;

    /*
     * WARNING - void declaration
     */
    public final boolean init(FArray inputArray, MCFSParams mcfsParams, String experimentName, String chartTitle) {
        void var2_2;
        void var1_1;
        void var3_3;
        this.myMCFSParams = mcfsParams;
        this.prefix = String.valueOf(mcfsParams.resFilesPATH) + (String)var3_3;
        this.calculatedDistances = 0;
        this.projectionsCounter = 0;
        this.attrNames = inputArray.getColNames(true);
        this.attrRI = GlobalStats.initImportances(this.myMCFSParams, inputArray);
        if (mcfsParams.buildID) {
            this.attrID = new AttributesID(this.attrNames, true, false);
        }
        this.confusionMatrix = inputArray.isTargetNominal() ? new ConfusionMatrix(inputArray.getColNames(true)[inputArray.getDecAttrIdx()], var1_1.getDecValuesStr()) : null;
        this.initChartFrame(mcfsParams, chartTitle);
        this.initLinearRegression();
        this.splitsStats = new StatsList();
        this.pc = new ProgressCounter(0.0f, var2_2.projectionsValue, new float[]{0.0f, 5.0f, 10.0f, 15.0f, 20.0f, 25.0f, 30.0f, 35.0f, 40.0f, 45.0f, 50.0f, 55.0f, 60.0f, 65.0f, 70.0f, 75.0f, 80.0f, 85.0f, 90.0f, 95.0f, 100.0f});
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private boolean initChartFrame(MCFSParams mcfsParams, String chartTitle) {
        if (mcfsParams.progressShow) {
            if (this.distanceChart != null) {
                this.distanceChart.dispose();
                this.distanceChart = null;
            }
            try {
                void var2_2;
                this.distanceChart = new ChartFrame("dmLab", (String)var2_2);
            }
            catch (HeadlessException headlessException) {
                System.err.println("Warning! Progress chart frame cannot be displayed.");
            }
        }
        return true;
    }

    public final boolean closeChartFrame() {
        if (this.distanceChart != null) {
            this.distanceChart.setVisible(false);
            this.distanceChart.dispose();
        }
        return true;
    }

    private void initLinearRegression() {
        this.myLinearRegression = new LinearRegression();
        this.xArray = new float[WINDOW_SIZE];
        int i = 0;
        while (i < this.xArray.length) {
            this.xArray[i] = i;
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static AttributesRI[] initImportances(MCFSParams mcfsParams, FArray inputArray) {
        void var3_3;
        String[] decValues = inputArray.getDecValuesStr();
        AttributesRI[] importances = new AttributesRI[1];
        if (mcfsParams.model == Classifier.ADX) {
            importances = new AttributesRI[1 + decValues.length];
        }
        int i = 0;
        while (i < importances.length) {
            importances[i] = new AttributesRI(inputArray);
            importances[i].addMeasure(new ProjectionMeasure(null));
            importances[i].addMeasure(new ClassifiersMeasure(null));
            importances[i].addMeasure(new NodesMeasure(null));
            if (mcfsParams.model == Classifier.J48 || mcfsParams.model == Classifier.M5) {
                importances[i].addMeasure(new J48RIMeasure(mcfsParams));
            } else if (mcfsParams.model == Classifier.SLIQ) {
                importances[i].addMeasure(new SliqRIMeasure(mcfsParams));
            } else if (mcfsParams.model == Classifier.ADX) {
                importances[i].addMeasure(new ADXRIMeasure(mcfsParams));
            }
            importances[i].addMeasure(new RINormMeasure(mcfsParams));
            importances[i].mainMeasureIdx = importances[i].getMeasureIndex(ImportanceMeasure.MEASURE_RINORM);
            importances[i].label = i == 0 ? "" : decValues[i - 1];
            importances[i].initImportances();
            ++i;
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized boolean updateSplitsStats(StatsList localSplitsStats) {
        void var1_1;
        return this.splitsStats.add((StatsList)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized boolean update(int jobId, ConfusionMatrix localMatrix, AttributesRI[] localImportances, AttributesID localAttrID2) {
        Object object;
        Object object2;
        if (this.projectionsCounter >= this.myMCFSParams.projectionsValue) {
            if (this.myMCFSParams.verbose) {
                System.out.println("[thread: " + jobId + "] Stop Criterion: projections = " + this.projectionsCounter);
            }
            return false;
        }
        this.projectionsCounter = (this.calculatedDistances + 1) * this.myMCFSParams.progressInterval;
        if (this.confusionMatrix != null) {
            this.confusionMatrix.add(localMatrix);
        }
        if (this.attrID != null) {
            this.attrID.addDependencies((AttributesID)localAttrID2);
        }
        int j = 0;
        while (j < this.attrRI.length) {
            block19: {
                if (this.attrRI[j] != null) {
                    this.attrRI[j].sumImportances(localImportances[j]);
                    this.attrRI[j].calcNormMeasure(this.myMCFSParams.splits);
                    if (this.myMCFSParams.saveResutFiles) {
                        String string = String.valueOf(this.prefix) + "_" + this.attrRI[j].label + "_" + MCFSParams.FILESUFIX_RI;
                        AttributesRI attributesRI = this.attrRI[j];
                        object2 = "csv";
                        object = DiscFunctions.getFileExtension(string);
                        object = ((String)object).equalsIgnoreCase((String)object2) ? string : String.valueOf(string) + "." + (String)object2;
                        try {
                            localAttrID2 = new FileWriter((String)object, false);
                        }
                        catch (IOException iOException) {
                            System.err.println("Error opening file. File: " + (String)object);
                            break block19;
                        }
                        try {
                            ((Writer)localAttrID2).write(attributesRI.toString());
                            ((OutputStreamWriter)localAttrID2).close();
                        }
                        catch (IOException localAttrID2) {
                            System.err.println("Error writing file. File: " + (String)object);
                            localAttrID2.printStackTrace();
                        }
                    }
                }
            }
            ++j;
        }
        this.newRank = this.attrRI[0].getTopRankingSize(this.attrRI[0].mainMeasureIdx, this.myMCFSParams.progressTopMinSize);
        if (this.oldRank != null) {
            float distance = this.newRank.compare(this.oldRank);
            float commonPart = this.newRank.commonPart(this.oldRank);
            float mAvg = 0.0f;
            float beta22 = 0.0f;
            if (this.distanceList.size() >= WINDOW_SIZE) {
                float[] yArray = this.distanceList.toArray(this.distanceList.size() - WINDOW_SIZE, this.distanceList.size());
                mAvg = (float)MathUtils.mean(ArrayUtils.float2double(yArray));
                object = yArray;
                yArray = this.xArray;
                LinearRegression beta22 = this.myLinearRegression;
                object2 = ArrayUtils.float2double(yArray);
                object = ArrayUtils.float2double((float[])object);
                beta22.calc((double[])object2, (double[])object);
                beta22 = (float)this.myLinearRegression.getBeta1();
            }
            if (this.calculatedDistances > 1) {
                this.projectionIdxList.add(this.projectionsCounter);
                this.distanceList.add(distance);
                this.commonPartList.add(commonPart);
                this.betaList.add(beta22);
                this.mAvgList.add(mAvg);
                if (this.distanceChart != null) {
                    ArrayList<DataSeries> series = new ArrayList<DataSeries>();
                    series.add(new DataSeries("distance", this.projectionIdxList.toArray(), this.distanceList.toArray(), true));
                    series.add(new DataSeries("common part", this.projectionIdxList.toArray(), this.commonPartList.toArray(), false));
                    series.add(new DataSeries("beta1", this.projectionIdxList.toArray(), this.betaList.toArray(), false));
                    this.distanceChart.setAxisLabels("projections number", "distance value");
                    this.distanceChart.draw(series);
                }
            }
            if (this.myMCFSParams.verbose) {
                void var3_6;
                void var2_4;
                void var1_1;
                System.out.println("*** PROJECTION: " + this.projectionsCounter + " [thread: " + (int)var1_1 + "] *** -> distance: " + DiscFunctions.formatFloat((double)var2_4, 4) + " commonPart: " + DiscFunctions.formatFloat((double)var3_6, 4) + " mAvg: " + DiscFunctions.formatFloat(mAvg, 4) + " beta1: " + DiscFunctions.formatFloat(beta22, 4));
            } else {
                String p = this.pc.getPercentValue(this.projectionsCounter);
                if (p != null) {
                    System.out.print(String.valueOf(p) + "% ");
                    if (p.equalsIgnoreCase("100")) {
                        System.out.print("\n");
                    }
                }
            }
        }
        this.oldRank = this.newRank;
        ++this.calculatedDistances;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final DataFrame getDistances() {
        void var1_1;
        DataFrame distancesDF = new DataFrame(this.distanceList.size(), 5);
        distancesDF.setColNames(new String[]{"projection", "distance", "commonPart", "mAvg", "beta1"});
        distancesDF.setColTypes(new short[]{1, 1, 1, 1, 1});
        distancesDF.setColumn(0, this.projectionIdxList.toArray());
        distancesDF.setColumn(1, this.distanceList.toArray());
        distancesDF.setColumn(2, this.commonPartList.toArray());
        distancesDF.setColumn(3, this.mAvgList.toArray());
        distancesDF.setColumn(4, this.betaList.toArray());
        return var1_1;
    }

    public final ConfusionMatrix getConfusionMatrix() {
        return this.confusionMatrix;
    }

    public final AttributesRI[] getAttrImportances() {
        return this.attrRI;
    }

    public final AttributesID getAttrConnections() {
        return this.attrID;
    }

    public final StatsList getSplitsStats() {
        return this.splitsStats;
    }

    public final Cutoff getCutoff() {
        return this.cutoff;
    }

    /*
     * WARNING - void declaration
     */
    public final void setCutoff(Cutoff cutoff) {
        void var1_1;
        this.cutoff = var1_1;
    }
}

