/*
 * Decompiled with CFR 0.152.
 */
package dmLab.classifier.adx.complex;

import dmLab.array.FArray;
import dmLab.array.functions.DiscFunctions;
import dmLab.classifier.adx.selector.Selector;
import dmLab.classifier.adx.selector.SelectorList;
import java.util.Arrays;

public final class Complex
implements Cloneable {
    protected int[] idSelectors;
    private float[] selectorsValues;
    private int[] selectorsAttributes;
    private float[] parentCovs;
    private int currentPosition;
    public float posCoverage;
    public float negCoverage;
    public float coverage;
    public float posSupport;
    public float negSupport;
    public boolean reproduce = true;

    public Complex(int[] selectors) {
        this.idSelectors = new int[selectors.length];
        int i = 0;
        while (i < selectors.length) {
            this.idSelectors[i] = selectors[i];
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    private Complex(Complex c) {
        void var1_1;
        this.idSelectors = (int[])c.idSelectors.clone();
        this.selectorsValues = (float[])c.selectorsValues.clone();
        this.selectorsAttributes = (int[])c.selectorsAttributes.clone();
        this.parentCovs = (float[])c.parentCovs.clone();
        this.currentPosition = c.currentPosition;
        this.posCoverage = c.posCoverage;
        this.negCoverage = c.negCoverage;
        this.coverage = c.coverage;
        this.posSupport = c.posSupport;
        this.negSupport = c.negSupport;
        this.reproduce = var1_1.reproduce;
    }

    public final Complex clone() {
        return new Complex(this);
    }

    public final int size() {
        return this.idSelectors.length;
    }

    /*
     * WARNING - void declaration
     */
    public final int getSelectorId(int position) {
        void var1_1;
        return this.idSelectors[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    public final double calcQuality(int qMethod) {
        void var1_1;
        return DiscFunctions.calc(this.posCoverage, this.negCoverage, (int)var1_1);
    }

    public final double calcPosProbability() {
        return this.posSupport / (this.negSupport + this.posSupport);
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        StringBuffer tmp = new StringBuffer();
        tmp.append(Arrays.toString(this.idSelectors));
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    public final String toString(SelectorList selectorsList, FArray array) {
        void var3_3;
        StringBuffer tmp = new StringBuffer();
        int j = 0;
        while (j < this.idSelectors.length) {
            if (j != 0) {
                tmp.append(" and ");
            }
            tmp.append(selectorsList.getSelector(this.idSelectors[j]).toString(array));
            ++j;
        }
        return var3_3.toString();
    }

    public final boolean covers(SelectorList selectorsList, FArray array, int eventIndex) {
        int size = this.idSelectors.length;
        int i = 0;
        while (i < size) {
            Selector tmpSelector = selectorsList.getSelector(this.idSelectors[i]);
            if (!tmpSelector.covers(array.readValue(tmpSelector.attrIndex, eventIndex))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public final boolean mergingPossible(SelectorList selectorsList, Complex complex, FArray array) {
        Complex complex2 = complex;
        if (this.idSelectors.length != complex2.idSelectors.length) {
            return false;
        }
        int i = 0;
        while (i < this.idSelectors.length) {
            Selector s1 = selectorsList.getSelector(this.idSelectors[i]);
            int n = i++;
            complex2 = complex;
            Selector s2 = selectorsList.getSelector(complex2.idSelectors[n]);
            if (s1.mergingPossible(s2, array)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean merge(SelectorList selectorsList, Complex complex, FArray array) {
        boolean bl;
        boolean merged = false;
        int i = 0;
        while (i < this.idSelectors.length) {
            Selector s1 = selectorsList.getSelector(this.idSelectors[i]).clone();
            int n = i;
            Complex complex2 = complex;
            Selector s2 = selectorsList.getSelector(complex2.idSelectors[n]);
            if (s1.merge(s2, array)) {
                int selectorId;
                this.idSelectors[i] = selectorId = selectorsList.addSelector(s1);
                bl = true;
            }
            ++i;
        }
        if (bl) {
            void var2_2;
            this.posCoverage += complex.posCoverage;
            this.negCoverage += complex.negCoverage;
            this.coverage += complex.coverage;
            this.posSupport += complex.posSupport;
            this.negSupport += var2_2.negSupport;
        }
        return bl;
    }

    public final boolean contains(SelectorList selectorsList, Complex complex, FArray array) {
        Complex complex2 = complex;
        if (this.idSelectors.length != complex2.idSelectors.length) {
            return false;
        }
        int i = 0;
        while (i < this.idSelectors.length) {
            Selector s1 = selectorsList.getSelector(this.idSelectors[i]);
            int n = i++;
            complex2 = complex;
            Selector s2 = selectorsList.getSelector(complex2.idSelectors[n]);
            if (s1.contains(s2, array)) continue;
            return false;
        }
        return true;
    }

    public final boolean betterThanSubSelectors_Q(SelectorList selectorsList, int qMethod) {
        double currQuality = DiscFunctions.calc(this.posCoverage, this.negCoverage, qMethod);
        int i = 0;
        while (i < this.idSelectors.length) {
            Selector selector = selectorsList.getSelector(this.idSelectors[i]);
            double selectorQuality = DiscFunctions.calc(selector.posCoverage, selector.negCoverage, qMethod);
            if (currQuality > selectorQuality) {
                return true;
            }
            ++i;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean betterThanParents_Q(int qMethod) {
        void var2_2;
        void var1_1;
        if (this.parentCovs == null) {
            System.err.println("Error! Table parentCovs is NULL!");
            return false;
        }
        double currQuality = DiscFunctions.calc(this.posCoverage, this.negCoverage, qMethod);
        double parentQuality_1 = DiscFunctions.calc(this.parentCovs[0], this.parentCovs[1], qMethod);
        double parentQuality_2 = DiscFunctions.calc(this.parentCovs[2], this.parentCovs[3], (int)var1_1);
        return currQuality > parentQuality_1 || var2_2 > parentQuality_2;
    }

    /*
     * WARNING - void declaration
     */
    public final void setParentsCovs(float parent1_PosCov, float parent1_NegCov, float parent2_PosCov, float parent2_NegCov) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.parentCovs = new float[4];
        this.parentCovs[0] = var1_1;
        this.parentCovs[1] = var2_2;
        this.parentCovs[2] = var3_3;
        this.parentCovs[3] = parent2_NegCov;
    }

    public final boolean containsSubsequence(Complex complex) {
        int i = 1;
        while (i < this.idSelectors.length) {
            if (this.idSelectors[i] != complex.idSelectors[i - 1]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public final boolean equalAttributes(Complex complex, SelectorList selectorsList) {
        int i = 0;
        while (i < this.idSelectors.length) {
            if (this.idSelectors.length == 1 && selectorsList.getSelector((int)this.idSelectors[i]).attrIndex != selectorsList.getSelector((int)complex.idSelectors[i]).attrIndex) {
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final void prepareToCoversFast(SelectorList selectorsList, int attrNumber) {
        this.selectorsValues = new float[attrNumber];
        this.selectorsAttributes = new int[this.idSelectors.length];
        int i = 0;
        while (i < this.idSelectors.length) {
            void var3_3;
            Selector selector = selectorsList.getSelector(this.idSelectors[i]);
            this.selectorsAttributes[i] = selector.attrIndex;
            this.selectorsValues[this.selectorsAttributes[i]] = var3_3.getValue(0);
            ++i;
        }
    }

    public final boolean coversFast(FArray array, int eventIndex) {
        int size = this.selectorsAttributes.length;
        int i = 0;
        while (i < size) {
            if (this.selectorsValues[this.selectorsAttributes[i]] != array.readValue(this.selectorsAttributes[i], eventIndex)) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

