/*
 * Decompiled with CFR 0.152.
 */
package com.chenlb.mmseg4j;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharNode {
    private int freq = -1;
    private int maxLen = 0;
    private KeyTree ktWordTails = new KeyTree();
    private int wordNum = 0;

    public void addWordTail(char[] cArray) {
        this.ktWordTails.add(cArray);
        ++this.wordNum;
        if (cArray.length > this.maxLen) {
            this.maxLen = cArray.length;
        }
    }

    public int getFreq() {
        return this.freq;
    }

    public void setFreq(int n) {
        this.freq = n;
    }

    public int wordNum() {
        return this.wordNum;
    }

    public int indexOf(char[] cArray, int n, int n2) {
        return this.ktWordTails.match(cArray, n + 1, n2) ? 1 : -1;
    }

    public int maxMatch(char[] cArray, int n) {
        return this.ktWordTails.maxMatch(cArray, n);
    }

    public ArrayList<Integer> maxMatch(ArrayList<Integer> arrayList, char[] cArray, int n) {
        return this.ktWordTails.maxMatch(arrayList, cArray, n);
    }

    public int getMaxLen() {
        return this.maxLen;
    }

    public void setMaxLen(int n) {
        this.maxLen = n;
    }

    private static class TreeNode {
        char key;
        Map<Character, TreeNode> subNodes;
        boolean alsoLeaf;

        public TreeNode(char c) {
            this.key = c;
            this.subNodes = new HashMap<Character, TreeNode>();
        }

        public void born(char c, TreeNode treeNode) {
            this.subNodes.put(Character.valueOf(c), treeNode);
        }

        public TreeNode subNode(char c) {
            return this.subNodes.get(Character.valueOf(c));
        }

        public boolean isAlsoLeaf() {
            return this.alsoLeaf;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class KeyTree {
        TreeNode head = new TreeNode(' ');

        public void add(char[] cArray) {
            if (cArray.length < 1) {
                return;
            }
            TreeNode treeNode = this.head;
            for (int i = 0; i < cArray.length; ++i) {
                TreeNode treeNode2 = treeNode.subNode(cArray[i]);
                if (treeNode2 == null) {
                    treeNode2 = new TreeNode(cArray[i]);
                    treeNode.born(cArray[i], treeNode2);
                }
                treeNode = treeNode2;
            }
            treeNode.alsoLeaf = true;
        }

        public int maxMatch(char[] cArray, int n) {
            int n2 = n - 1;
            TreeNode treeNode = this.head;
            for (int i = n; i < cArray.length && (treeNode = treeNode.subNode(cArray[i])) != null; ++i) {
                if (!treeNode.isAlsoLeaf()) continue;
                n2 = i;
            }
            return n2 - n + 1;
        }

        public ArrayList<Integer> maxMatch(ArrayList<Integer> arrayList, char[] cArray, int n) {
            TreeNode treeNode = this.head;
            for (int i = n; i < cArray.length && (treeNode = treeNode.subNode(cArray[i])) != null; ++i) {
                if (!treeNode.isAlsoLeaf()) continue;
                arrayList.add(i - n + 1);
            }
            return arrayList;
        }

        public boolean match(char[] cArray, int n, int n2) {
            TreeNode treeNode = this.head;
            for (int i = 0; i < n2; ++i) {
                if ((treeNode = treeNode.subNode(cArray[n + i])) != null) continue;
                return false;
            }
            return treeNode.isAlsoLeaf();
        }
    }
}

