% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processMI.r
\name{processMI.fit.mult.impute}
\alias{processMI.fit.mult.impute}
\title{processMI.fit.mult.impute}
\usage{
\method{processMI}{fit.mult.impute}(
  object,
  which = c("validate", "calibrate"),
  plotall = TRUE,
  nind = 0,
  ...
)
}
\arguments{
\item{object}{a fit object created by \code{fit.mult.impute}}

\item{which}{specifies which component of the extra output should be processed}

\item{plotall}{set to \code{FALSE} when \code{which='calibrate'} to suppress having \code{ggplot} render a graph showing calibration curves produced separately for all the imputations}

\item{nind}{set to a positive integer to use base graphics to plot a matrix of graphs, one each for the first \code{nind} imputations, and the overall average calibration curve at the end}

\item{...}{ignored}
}
\value{
an object like a \code{validate} or \code{calibrate} result obtained when no multiple imputation was done.  This object is suitable for \code{print} and \code{plot} methods for these kinds of resampling validation objects.
}
\description{
Process Special Multiple Imputation Output From \code{fit.mult.impute}
}
\details{
Processes a \code{funresults} object stored in a fit object created by \code{fit.mult.impute} when its \code{fun} argument was used.  These objects are typically named \code{validate} or \code{calibrate} and represent bootstrap or cross-validations run separately for each imputation.  See \href{https://hbiostat.org/rmsc/validate.html#sec-val-mival}{this} for a case study.
}
\seealso{
\code{\link[Hmisc:transcan]{Hmisc::fit.mult.impute()}}
}
\author{
Frank Harrell
}
