% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endpoint_tables.R
\name{get_last_n_exchangerate_tables}
\alias{get_last_n_exchangerate_tables}
\title{Retrieves the last n exchange rate tables.}
\usage{
get_last_n_exchangerate_tables(table, n)
}
\arguments{
\item{table}{specifies which table should be fetched.}

\item{n}{number of exchange rate tables to retrieve.}
}
\value{
nbp_api_response object containing the last n
exchange rate tables.
}
\description{
Retrieves the last n exchange rate tables.
}
\examples{

\donttest{
## Fetch the last 3 A exchange rate tables
response <- get_last_n_exchangerate_tables("A", 3)

## Preview response content
response$content
}

}
\seealso{
\url{http://api.nbp.pl/#kursyWalut}

Other tables: \code{\link{get_current_exchangerate_table}},
  \code{\link{get_exchangerate_table_from}},
  \code{\link{get_exchangerate_tables_from_interval}},
  \code{\link{get_todays_exchangerate_table}}
}
\concept{tables}
