% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endpoint_tables.R
\name{get_exchangerate_table_from}
\alias{get_exchangerate_table_from}
\title{Retrieves the exchange rate table from a specific date.}
\usage{
get_exchangerate_table_from(table, date)
}
\arguments{
\item{table}{specifies which table should be fetched.}

\item{date}{date from which the exchange rate table should
be fetched.}
}
\value{
nbp_api_response object containing the exchange rate
table from the specified date.
}
\description{
Retrieves the exchange rate table from a specific date.
}
\details{
As exchange rate tables are not published on the weekends
fetching values from a weekend date will result in a 404
error. In those cases the function returns an error with an
appropriate message.
}
\examples{

\donttest{
  tryCatch({
      ## Fetch the A exchange rate table from a week ago
      response <- get_exchangerate_table_from("A", Sys.Date() - 7)
      ## Preview response content
      response$content
    },
    error = function(e) message(e)
  )

}

}
\seealso{
\url{https://api.nbp.pl/#kursyWalut}

Other tables: 
\code{\link{get_current_exchangerate_table}()},
\code{\link{get_exchangerate_tables_from_interval}()},
\code{\link{get_last_n_exchangerate_tables}()},
\code{\link{get_todays_exchangerate_table}()}
}
\concept{tables}
