% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/catalogue.R
\name{catalogue}
\alias{catalogue}
\title{List of stations from UK NRFA}
\usage{
catalogue(bbox = NULL, column_name = NULL, column_value = NULL,
  min_rec = NULL, all = TRUE)
}
\arguments{
\item{bbox}{this is a geographical bounding box (e.g. list(lon_min = -3.82,
lon_max = -3.63, lat_min = 52.43, lat_max = 52.52))}

\item{column_name}{name of column to filter}

\item{column_value}{string to search in column_name}

\item{min_rec}{minimum number of recording years}

\item{all}{if TRUE it returns all the available metadata. If FALSE, it
returns only the following columns: id, name, river, hydrometricArea,
operator, haName, catchmentArea, altitude, lat, lon.}
}
\value{
tibble table containing the list of stations and related metadata
}
\description{
This function pulls the list of stations (and related metadata),
falling within a given bounding box, from the CEH National River Flow Archive
website.
}
\details{
coordinates of bounding box are required in WGS84 (EPSG: 4326).
If BB coordinates are missing, the function returns the list corresponding to
the maximum extent of the network.
}
\examples{
\dontrun{
  # Retrieve all the stations in the network
  x <- catalogue()

  # Define a bounding box:
  bbox <- list(lon_min=-3.82, lon_max=-3.63, lat_min=52.43, lat_max=52.52)
  # Get stations within the bounding box
  x <- catalogue(bbox)

  # Get stations based on minimum catchment area
  x <- catalogue(column_name = "catchment-area", column_value = 2000)

  # Get stations based on minimum number of recording years
  x <- catalogue(min_rec=30)
}

}
\author{
Claudia Vitolo
}
