% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checklist.R
\name{checklist}
\alias{checklist}
\title{Create a checklist.}
\usage{
checklist(scientificname = NULL, taxonid = NULL, datasetid = NULL,
  nodeid = NULL, areaid = NULL, startdate = NULL, enddate = NULL,
  startdepth = NULL, enddepth = NULL, geometry = NULL, redlist = NULL,
  exclude = NULL, verbose = FALSE)
}
\arguments{
\item{scientificname}{the scientific name.}

\item{taxonid}{the taxon identifier (WoRMS AphiaID).}

\item{datasetid}{the dataset identifier.}

\item{nodeid}{the OBIS node identifier.}

\item{areaid}{the OBIS area identifier.}

\item{startdate}{the earliest date on which occurrence took place.}

\item{enddate}{the latest date on which the occurrence took place.}

\item{startdepth}{the minimum depth below the sea surface.}

\item{enddepth}{the maximum depth below the sea surface.}

\item{geometry}{a WKT geometry string.}

\item{redlist}{include only IUCN Red List species.}

\item{exclude}{quality flags to be excluded from the results.}

\item{verbose}{logical. Optional parameter to enable verbose logging (default = \code{FALSE}).}
}
\value{
The checklist.
}
\description{
Create a checklist.
}
\examples{
taxa <- checklist(scientificname = "Tellinidae")
taxa <- checklist(geometry = "POLYGON ((2.3 51.8, 2.3 51.6, 2.6 51.6, 2.6 51.8, 2.3 51.8))")
taxa <- checklist(areaid = 10181)
}
