% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robsurvey.R
\name{trimwgt}
\alias{trimwgt}
\alias{weighted_mean_trimmed}
\alias{weighted_total_trimmed}
\alias{svymean_trimmed}
\alias{svytotal_trimmed}
\title{Weighted trimmed mean and trimmed total}
\usage{
weighted_mean_trimmed(x, w, LB = 0.05, UB = 1 - LB, na.rm = FALSE)

weighted_total_trimmed(x, w, LB = 0.05, UB = 1 - LB, na.rm = FALSE)

svymean_trimmed(x, design, LB = 0.05, UB = 1 - LB, ...)

svytotal_trimmed(x, design, LB = 0.05, UB = 1 - LB, ...)
}
\arguments{
\item{x}{numeric vector (\code{weighted_mean_trimmed} or \code{weighted_total_trimmed});
a formula object or variable name (\code{svymean_trimmed} or \code{svytotal_trimmed})}

\item{w}{numeric vector of weights}

\item{LB}{lower bound of trimming, such that \eqn{0 \leq LB < UB \leq 1}}

\item{UB}{upper bound of trimming, such that \eqn{0 \leq LB < UB \leq 1}}

\item{na.rm}{a logical value indicating whether \code{NA} values should be
stripped before the computation proceeds.}

\item{design}{a \code{survey.design} object (see \link[survey]{svydesign} in \pkg{survey})}

\item{...}{additional arguments (not used)}
}
\value{
Estimate (scalar) or object of class \code{svystat.rob}
}
\description{
Weighted trimmed estimators of the mean and total are available in two forms:
\itemize{
   \item \strong{bare-bone} functions: \code{weighted_mean_trimmed} and
 \code{weighted_total_trimmed},
   \item estimation \strong{methods}: \code{svymean_trimmed} and
 \code{svytotal_trimmed} (incl. variance estimation
 based on the functionality of the \pkg{survey} package).
}
}
\details{
\describe{
   \item{\emph{Overview}}{
   Robust trimmed Horvitz--Thompson total or Hajek mean
 \itemize{
 \item bare-bone functions: return the estimate (no variance estimation)
 \item estimation methods on the basis of \pkg{survey} (incl. variance estimation)
 }
   }
   \item{\emph{Variance}}{
   Variance estimates of the mean or total estimator are computed as first-order
   linearization using the design-based-estimation capabilities available
   in package \pkg{survey}.
   }
   \item{\emph{Domain estimation}}{
   Estimates for domains can be obtained using the \link[survey]{svyby}
   wrapper in the \pkg{survey} package (see examples).
   }
}
}
\note{
\code{trimwgt} is a generic name for the functions documented.
}
\section{Utility functions}{

For the methods \code{svymean_trimmed} and \code{svytotal_trimmed}, the following
utility functions can be used
\itemize{
   \item \code{summary} gives a summary of the estimation properties
   \item \code{\link{robweights}} retrieves the robustness weights
   \item \code{coef}, \code{vcov}, \code{residuals}, and \code{fitted}
 retrieve, respectively, the estimate, variance, residuals and fitted
 values
}
}

\examples{
library(survey)
data(api)
dstrat <- svydesign(id=~1, strata=~stype, weights=~pw, data=apistrat, fpc=~fpc)
svymean_trimmed(~api00, dstrat, LB = 0.05)
# Domain estimates
svyby(~api00, by = ~stype, design = dstrat, svymean_trimmed, LB = 0.1)
}
\seealso{
\code{\link{svymean_huber}}, \code{\link{svytotal_huber}},
\code{\link{svymean_winsorized}}, \code{\link{svytotal_winsorized}},
\code{\link{weighted_mean_huber}}, \code{\link{weighted_total_huber}},
\code{\link{weighted_mean_winsorized}}, \code{\link{weighted_total_winsorized}}
}
