% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robsurvey.R
\name{wgtmeantotal}
\alias{wgtmeantotal}
\alias{weighted_total}
\alias{weighted_mean}
\title{Weighted total and mean (Horvitz-Thompson and Hajek estimators)}
\usage{
weighted_total(x, w, na.rm = FALSE)

weighted_mean(x, w, na.rm = FALSE)
}
\arguments{
\item{x}{a numeric vector}

\item{w}{a numeric vector of weights}

\item{na.rm}{a logical value indicating whether \code{NA} values
should be stripped before the computation proceeds.}
}
\value{
Estimate (scalar)
}
\description{
Weighted total and mean (Horvitz-Thompson and Hajek estimators)
}
\details{
-
}
\note{
\code{wgtmeantotal} is a generic name for the functions documented.
}
\examples{
x <- c(0.1, 0.35, 0.05, 0.1, 0.15, 0.05, 0.2)
weighted_total(x, x)
x <- c(0.1, 0.35, 0.05, 0.1, 0.15, 0.05, 0.2)
weighted_mean(x, x)
}
