% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mask_source.R, R/mask_sources.R,
%   R/mask_utterances.R
\name{mask_source}
\alias{mask_source}
\alias{mask_sources}
\alias{mask_utterances}
\title{Masking sources}
\usage{
mask_source(
  input,
  output = NULL,
  proportionToMask = 1,
  preventOverwriting = rock::opts$get(preventOverwriting),
  encoding = rock::opts$get(encoding),
  rlWarn = rock::opts$get(rlWarn),
  maskRegex = "[[:alnum:]]",
  maskChar = "X",
  perl = TRUE,
  silent = rock::opts$get(silent)
)

mask_sources(
  input,
  output,
  proportionToMask = 1,
  outputPrefix = "",
  outputSuffix = "_masked",
  maskRegex = "[[:alnum:]]",
  maskChar = "X",
  perl = TRUE,
  recursive = TRUE,
  filenameRegex = ".*",
  filenameReplacement = c("_PRIVATE_", "_public_"),
  preventOverwriting = rock::opts$get(preventOverwriting),
  encoding = rock::opts$get(encoding),
  silent = rock::opts$get(silent)
)

mask_utterances(
  input,
  proportionToMask = 1,
  maskRegex = "[[:alnum:]]",
  maskChar = "X",
  perl = TRUE
)
}
\arguments{
\item{input}{For \code{mask_utterance}, a character vector where each element is one
utterance; for \code{mask_source}, either a character vector containing the text of the
relevant source \emph{or} a path to a file that contains the source text; for \code{mask_sources},
a path to a directory that contains the sources to mask.}

\item{output}{For \code{mask_source}, if not \code{NULL}, this is the name (and path) of the
file in which to save the processed source (if it \emph{is} \code{NULL}, the result will be
returned visibly). For \code{mask_sources}, \code{output} is mandatory and is the path to the
directory where to store the processed sources. This path will be created with a
warning if it does not exist. An exception is if "\code{same}" is specified - in that
case, every file will be written to the same directory it was read from.}

\item{proportionToMask}{The proportion of utterances to mask, from 0 (none) to
1 (all).}

\item{preventOverwriting}{Whether to prevent overwriting of output files.}

\item{encoding}{The encoding of the source(s).}

\item{rlWarn}{Whether to let \code{\link[=readLines]{readLines()}} warn, e.g. if files do not end
with a newline character.}

\item{maskRegex}{A regular expresssion (regex) specifying the characters to
mask (i.e. replace with the masking character).}

\item{maskChar}{The character to replace the character to mask with.}

\item{perl}{Whether the regular expression is a perl regex or not.}

\item{silent}{Whether to suppress the warning about not editing the cleaned source.}

\item{outputPrefix, outputSuffix}{The prefix and suffix to add to the
filenames when writing the processed files to disk.}

\item{recursive}{Whether to search all subdirectories (\code{TRUE}) as well or not.}

\item{filenameRegex}{A regular expression to match against located files; only
files matching this regular expression are processed.}

\item{filenameReplacement}{A character vector with two elements that represent,
respectively, the \code{pattern} and \code{replacement} arguments of the \code{\link[=gsub]{gsub()}} function.
In other words, the first argument specifies a regular expression to search for
in every processed filename, and the second argument specifies a regular
expression that replaces any matches with the first argument. Set to \code{NULL} to
not perform any replacement on the output file name.}
}
\value{
A character vector for \code{mask_utterance} and \code{mask_source}, or a list of
character vectors, for \code{mask_sources}.
}
\description{
These functions can be used to mask a set of utterances or one or more sources.
}
\examples{
### Mask text but not the codes
rock::mask_utterances(
  paste0(
    "Lorem ipsum dolor sit amet, consectetur adipiscing ",
    "elit. [[expAttitude_expectation_73dnt5z1>earplugsFeelUnpleasant]]"
  )
)

}
