% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutates.R
\name{sort_tomic}
\alias{sort_tomic}
\title{Sort Triple Omic}
\usage{
sort_tomic(
  tomic,
  sort_type,
  sort_table,
  sort_variables = NULL,
  value_var = NULL
)
}
\arguments{
\item{tomic}{Either a \code{tidy_omic} or \code{triple_omic} object}

\item{sort_type}{\describe{
  \item{hclust}{Arrange samples by hierarchical clustering of a provided
    \code{value_var}}
  \item{arrange}{Arrange samples by the factor or alphanumeric ordering of
    a set of \code{sort_variables}}
}}

\item{sort_table}{samples or features}

\item{sort_variables}{A set of attributes in sort_table to sort with in
\code{arrange}.}

\item{value_var}{An abundance value to use with \code{hclust}}
}
\value{
A \code{tomic} object where feature or sample primary keys have
  been turned into a factor reflecting how they are sorted.
}
\description{
Sort a dataset's features or samples
}
\details{
\code{sort_tomic} supports the reordering of features or samples using
  either hierarchical clustering or based on the levels of other variables.
  Sorting occurs by turning either the feature or sample primary key
  into a factor whose levels reflect the sort.
}
\examples{

library(dplyr)

sort_tomic(brauer_2008_triple,
  sort_type = "arrange", sort_table = "samples",
  sort_variables = c("nutrient", "DR")
) \%>\%
  sort_tomic(
    sort_type = "hclust",
    sort_table = "features",
    value_var = "expression"
  )
}
