% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_backups.R
\name{backup_info}
\alias{backup_info}
\alias{list_backups}
\alias{n_backups}
\alias{newest_backup}
\alias{oldest_backup}
\title{Discover existing backups}
\usage{
backup_info(file, backup_dir = dirname(file))

list_backups(file, backup_dir = dirname(file))

n_backups(file, backup_dir = dirname(file))

newest_backup(file, backup_dir = dirname(file))

oldest_backup(file, backup_dir = dirname(file))
}
\arguments{
\item{file}{\code{character} scalar: Path to a file.}

\item{backup_dir}{\code{character} scalar. The directory in which the backups
of \code{file} are stored (defaults to \code{dirname(file)})}
}
\value{
\code{backup_info()} returns a \code{data.frame} similar to the output of
\code{\link[=file.info]{file.info()}}

\code{list_backups()} returns the paths to all backups of \code{file}

\code{n_backups()} returns the number of backups of \code{file} as an \code{integer}
scalar

\code{newest_backup()} and \code{oldest_backup()} return the paths to the
newest or oldest backup of \code{file} (or an empty \code{character} vector if none exist)
}
\description{
These function return information on the backups of a file (if any exist)
}
\section{Intervals}{


In \strong{rotor}, an interval is a character string in the form
\code{"<number> <interval>"}. The following intervals are possible:
\code{"day(s)"}, \code{"week(s)"}, \code{"month(s)"}, \code{"quarter(s)"}, \code{"year(s)"}.
The plural \code{"s"} is optional (so \code{"2 weeks"} and \code{"2 week"} are equivalent).
Please be aware that weeks are
\href{https://en.wikipedia.org/wiki/ISO_week_date}{ISOweeks}
and start on Monday (not Sunday as in some countries).

Interval strings can be used as arguments when backing up or rotating files,
or for pruning backup queues (i.e. limiting the number of backups of a
single) file.

When rotating/backing up \code{"1 months"} means "make a new backup if the last
backup is from the preceding month". E.g if the last backup of \code{myfile}
is from \code{2019-02-01} then \code{backup_time(myfile, age = "1 month")} will only
create a backup if the current date is at least \code{2019-03-01}.

When pruning/limiting backup queues, \code{"1 year"} means "keep at least most
one year worth of backups". So if you call
\code{backup_time(myfile, max_backups = "1 year")} on \code{2019-03-01}, it will create
a backup and then remove all backups of \code{myfile} before \code{2019-01-01}.
}

\examples{
# setup example files
tf <- tempfile("test", fileext = ".rds")
saveRDS(cars, tf)
backup(tf)
backup(tf)

backup_info(tf)
list_backups(tf)
n_backups(tf)
newest_backup(tf)
oldest_backup(tf)

# cleanup
prune_backups(tf, 0)
n_backups(tf)
file.remove(tf)
}
\seealso{
\code{\link[=rotate]{rotate()}}
}
