% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_core_plot.R
\name{plotTypes}
\alias{plotTypes}
\alias{getAvailablePlotTypes}
\title{Get Available Plot Types}
\usage{
plotTypes(
  obj,
  output = c("numeric", "caption", "numcap", "capnum"),
  numberInCaptionEnabled = FALSE
)

getAvailablePlotTypes(
  obj,
  output = c("numeric", "caption", "numcap", "capnum"),
  numberInCaptionEnabled = FALSE
)
}
\arguments{
\item{obj}{The object for which the plot types shall be identified, e.g. produced by
\code{\link{getDesignGroupSequential}} or \code{\link{getSampleSizeMeans}}.}

\item{output}{The output type. Can be one of \code{c("numeric", "caption", "numcap", "capnum")}.}

\item{numberInCaptionEnabled}{If \code{TRUE}, the number will be added to the
caption, default is \code{FALSE}.}
}
\value{
Depending on how the \code{output} is specified,
a numeric vector, a character vector, or a list will be returned.
}
\description{
Function to identify the available plot types of an object.
}
\details{
\code{plotTypes} and \code{getAvailablePlotTypes} are equivalent, i.e.,
\code{plotTypes} is a short form of \code{getAvailablePlotTypes}.

\code{output}:
\enumerate{
  \item \code{numeric}: numeric output
  \item \code{caption}: caption as character output
  \item \code{numcap}:  list with number and caption
  \item \code{capnum}:  list with caption and number
}
}
\examples{
design <- getDesignInverseNormal(kMax = 2)
getAvailablePlotTypes(design, "numeric")
plotTypes(design, "caption")
getAvailablePlotTypes(design, "numcap")
plotTypes(design, "capnum")

}
