# here is a little portion of the SOL1 gene
seqs <- c("ATGGCGACGAAGGCCGTGTGCGTGCTGAAGGGCGACGGCCCAGTGCAGG
           GCATCATCAATTTCGAGCAGAAGGCAAGGGCTGGGACGGAGGCTTGTTT
           GCGAGGCCGCTCCCACCCGCTCGTCCCCCCGCGCACCTTTGCTAGGAGC
           GGGTCGC----CCGCCAGGC-CTCGGGGCCGCCCTGGTCCAGCGCCCGG
           TCCCGGCCCGTGCCGCCCGGTCGGTGCCTTCGCCCCCAGCGGTGCGGTG
           CCCAAGTGCTGAGTCACCGGGCGGGCCCGGGC----GCGGGGCGTGGGA
           ---------CCGAGGCCGCCGCGGG",
          "ATGGCGACGAAGGCCGTGTGCGTGCTGAAGGGCGATGGCCCAGTGCAGG
           GCATCATCAATTTCGAGCAGAAGGCAAGGGCTGGGACGGAGGCTTGTTT
           GCGAGGCCGCTCCTACCCGCTCGTCCCCCCGCGCACCTTTGCTAGGAGC
           GGGTCGC----CCGCCAGGC-CTCGGGGCTGCCCTGGTCCAGCGCCCGG
           TCCCGGCCCGTGCCGCCCGGTCGGTGCCTTCGCCCCCAGCGGTGCGGTG
           CCCAAGTGCTGAGTCACCGGGCGGGCCCGGGC----GCGGGGTGTGGGA
           ---------CCGAGGCCGCCGCGGG",
          "ATGGCGATGAAAGCGGTGTGCGTGCTGAAGGGCGACGGTCCGGTGCAGG
           GAACCATCCACTTCGAGCAGAAGGCAAGGCCCGGGGC------------
           ----------------------------------------GCGGGGCGC
           AGGCCGCGGTGACGCGGCGCACCTGTGCGGGAGCACGCCACGCCCCCG-
           CCACGGCCTGAG----------------------CCCG-----------
           -CTAAGTGCTGAGTCACC--GTGGCCTGGGGCAGGGGCTGGGCGCCGGG
           AAGCGAGGCCCGGGGC-GCCGC***")
seqs <- gsub("\\s", "", seqs) #remove whitespace from seqs
align <- msa(seqs, names=c("hg19", "panTro2", "mm9"))

translate.msa(align)
translate.msa(msa(c("NNATGGCCACG")))
translate.msa(msa(c("NNATGGCCACG")), frame=3)
translate.msa(msa(c("NNATGGCCACG", "AT--GGCCACG")))
translate.msa(msa(c("NNATGGCCACG", "AT--GGCCACG")), one.frame=FALSE)
translate.msa(msa(c("NNATGGCCACG", "AT--GGCCACG")), one.frame=FALSE, frame=c(3,1))
